/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.Target;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;

@Deprecated
public class PhaseSpell
extends TargetingSpell {
    private static int MAX_RETRY_COUNT = 8;
    private static int RETRY_INTERVAL = 10;
    private int retryCount = 0;
    private String targetWorldName = "";

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        LivingEntity entity;
        Location targetLocation = null;
        Target target = this.getTarget();
        Entity e = target.getEntity();
        LivingEntity livingEntity = entity = e != null && e instanceof LivingEntity ? (LivingEntity)e : null;
        if (entity == null) {
            return SpellResult.NO_TARGET;
        }
        if (entity != this.mage.getEntity() && this.isSuperProtected((Entity)entity)) {
            return SpellResult.NO_TARGET;
        }
        Location playerLocation = entity.getLocation();
        String worldName = playerLocation.getWorld().getName();
        if (parameters.contains("target_world")) {
            World targetWorld = this.getWorld(parameters.getString("target_world"), parameters.getBoolean("load", true));
            if (targetWorld == null) {
                return SpellResult.INVALID_WORLD;
            }
            float scale = (float)parameters.getDouble("scale", 1.0);
            targetLocation = targetWorld.getEnvironment() == World.Environment.THE_END ? targetWorld.getSpawnLocation() : new Location(targetWorld, playerLocation.getX() * (double)scale, playerLocation.getY(), playerLocation.getZ() * (double)scale);
        } else if (parameters.contains("worlds")) {
            ConfigurationSection worldMap = parameters.getConfigurationSection("worlds");
            if (!worldMap.contains(worldName)) {
                return SpellResult.NO_TARGET;
            }
            ConfigurationSection worldNode = worldMap.getConfigurationSection(worldName);
            World targetWorld = this.getWorld(worldNode.getString("target"), worldNode.getBoolean("load", true));
            float scale = (float)worldNode.getDouble("scale", 1.0);
            if (targetWorld != null) {
                targetLocation = new Location(targetWorld, playerLocation.getX() * (double)scale, playerLocation.getY(), playerLocation.getZ() * (double)scale);
            }
        } else if (worldName.contains("_the_end")) {
            World targetWorld = Bukkit.getWorld((String)(worldName = worldName.replace("_the_end", "")));
            if (targetWorld != null) {
                targetLocation = targetWorld.getSpawnLocation();
            }
        } else if (worldName.contains("_nether")) {
            World targetWorld = Bukkit.getWorld((String)(worldName = worldName.replace("_nether", "")));
            if (targetWorld != null) {
                targetLocation = new Location(targetWorld, playerLocation.getX() * 8.0, playerLocation.getY(), playerLocation.getZ() * 8.0);
            }
        } else {
            World targetWorld = Bukkit.getWorld((String)(worldName = worldName + "_nether"));
            if (targetWorld != null) {
                targetLocation = new Location(targetWorld, playerLocation.getX() / 8.0, Math.min(125.0, playerLocation.getY()), playerLocation.getZ() / 8.0);
            }
        }
        if (targetLocation == null) {
            return SpellResult.NO_TARGET;
        }
        this.retryCount = 0;
        this.tryPhase(entity, targetLocation);
        return SpellResult.CAST;
    }

    @Nullable
    protected World getWorld(String worldName, boolean loadWorld) {
        World world = Bukkit.getWorld((String)worldName);
        if (world == null && loadWorld) {
            Bukkit.getLogger().info("Loading world: " + worldName);
            world = this.controller.createWorld(worldName);
            if (world == null) {
                Bukkit.getLogger().warning("Failed to load world: " + worldName);
                return null;
            }
        }
        if (world == null) {
            Bukkit.getLogger().warning("Could not load world: " + worldName);
        }
        return world;
    }

    protected void tryPhase(final LivingEntity entity, final Location targetLocation) {
        if (!CompatibilityLib.getCompatibilityUtils().checkChunk(targetLocation) && this.retryCount < MAX_RETRY_COUNT) {
            Plugin plugin = this.controller.getPlugin();
            final PhaseSpell me = this;
            Bukkit.getScheduler().scheduleSyncDelayedTask(plugin, new Runnable(){

                @Override
                public void run() {
                    me.tryPhase(entity, targetLocation);
                }
            }, (long)RETRY_INTERVAL);
            return;
        }
        Location playerLocation = entity.getLocation();
        targetLocation.setYaw(playerLocation.getYaw());
        targetLocation.setPitch(playerLocation.getPitch());
        Location destination = this.tryFindPlaceToStand(targetLocation);
        if (destination != null) {
            this.targetWorldName = destination.getWorld().getName();
            entity.teleport(destination);
        }
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        this.targetWorldName = this.controller.getMessages().get("worlds." + this.targetWorldName + ".name", this.targetWorldName);
        return message.replace("$world_name", this.targetWorldName);
    }
}

