/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.block.BrushMode;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.batch.FillBatch;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class FillSpell
extends BrushSpell {
    private static final int DEFAULT_MAX_DIMENSION = 128;
    private Block targetBlock = null;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        boolean hasPermission;
        boolean singleBlock = this.getTargetType() != TargetType.SELECT;
        Block targetBlock = this.getTargetBlock();
        if (!singleBlock && parameters.getBoolean("select_self", true) && this.isLookingDown()) {
            targetBlock = this.mage.getLocation().getBlock().getRelative(BlockFace.DOWN);
        }
        if (targetBlock == null) {
            return SpellResult.NO_TARGET;
        }
        MaterialBrush buildWith = this.getBrush().getCopy();
        boolean bl = hasPermission = buildWith != null && buildWith.isErase() ? this.hasBreakPermission(targetBlock) : this.hasBuildPermission(targetBlock);
        if (!hasPermission) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (singleBlock) {
            this.deactivate();
            if (this.isIndestructible(targetBlock)) {
                return SpellResult.NO_TARGET;
            }
            this.registerForUndo(targetBlock);
            buildWith.setTarget(targetBlock.getLocation());
            buildWith.update(this.mage, targetBlock.getLocation());
            buildWith.modify(targetBlock);
            this.controller.updateBlock(targetBlock);
            this.registerForUndo();
            return SpellResult.CAST;
        }
        if (this.targetLocation2 != null) {
            this.targetBlock = this.targetLocation2.getBlock();
        }
        if (this.targetBlock != null) {
            Location centerLocation = this.targetBlock.getLocation();
            Location secondLocation = this.targetBlock.getLocation();
            if (buildWith.getMode() == BrushMode.MAP) {
                centerLocation = targetBlock.getLocation();
                centerLocation.setX(Math.floor((centerLocation.getX() + secondLocation.getX()) / 2.0));
                centerLocation.setY(Math.floor((centerLocation.getY() + secondLocation.getY()) / 2.0));
                centerLocation.setZ(Math.floor((centerLocation.getZ() + secondLocation.getZ()) / 2.0));
            }
            buildWith.setTarget(this.targetBlock.getLocation(), centerLocation);
            FillBatch batch = new FillBatch(this, secondLocation, targetBlock.getLocation(), buildWith);
            boolean consumeBlocks = parameters.getBoolean("consume", false);
            boolean lockChunks = parameters.getBoolean("lock_chunks", false);
            batch.setConsume(consumeBlocks);
            batch.setLockChunks(lockChunks);
            UndoList undoList = this.getUndoList();
            if (undoList != null && !this.currentCast.isConsumeFree()) {
                undoList.setConsumed(consumeBlocks);
            }
            int maxDimension = parameters.getInt("max_dimension", 128);
            maxDimension = parameters.getInt("md", maxDimension);
            maxDimension = (int)(this.mage.getConstructionMultiplier() * (float)maxDimension);
            if (!batch.checkDimension(maxDimension)) {
                return SpellResult.FAIL;
            }
            boolean success = this.mage.addBatch(batch);
            return success ? SpellResult.CAST : SpellResult.FAIL;
        }
        this.setSelectedLocation(targetBlock.getLocation());
        this.targetBlock = targetBlock;
        this.activate();
        return SpellResult.TARGET_SELECTED;
    }

    @Override
    protected void onFinalizeCast(SpellResult result) {
        if (result != SpellResult.TARGET_SELECTED) {
            this.deactivate(false, true, false);
        }
    }

    @Override
    protected boolean isBatched() {
        return true;
    }

    @Override
    public boolean onCancelSelection() {
        return this.targetBlock != null;
    }

    @Override
    public void onDeactivate() {
        this.targetBlock = null;
        this.setSelectedLocation(null);
    }
}

