/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.api.protection.BlockBreakManager;
import com.elmakers.mine.bukkit.api.protection.BlockBuildManager;
import com.elmakers.mine.bukkit.api.protection.CastPermissionManager;
import com.elmakers.mine.bukkit.api.protection.EntityTargetingManager;
import com.elmakers.mine.bukkit.api.protection.PVPManager;
import com.elmakers.mine.bukkit.api.protection.PlayerWarp;
import com.elmakers.mine.bukkit.api.protection.PlayerWarpManager;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.protection.PreciousStonesAPI;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PreciousStonesManager
implements BlockBuildManager,
BlockBreakManager,
PVPManager,
CastPermissionManager,
EntityTargetingManager,
PlayerWarpManager {
    private boolean enabled = false;
    private boolean override = true;
    private PreciousStonesAPI api;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public boolean isEnabled() {
        return this.enabled && this.api != null && this.api.isEnabled();
    }

    public void initialize(Plugin plugin) {
        if (this.enabled) {
            try {
                Plugin psPlugin = plugin.getServer().getPluginManager().getPlugin("PreciousStones");
                if (psPlugin != null) {
                    this.api = new PreciousStonesAPI(plugin, psPlugin);
                    plugin.getLogger().info("PreciousStones found, will respect build and PVP permissions for protection fields");
                    plugin.getLogger().info("Disable warping to fields in recall config with allow_fields: false");
                }
            }
            catch (Throwable throwable) {}
        } else {
            plugin.getLogger().info("PreciousStones manager disabled, field protection and pvp checks will not be used.");
            this.api = null;
        }
    }

    @Override
    public boolean isPVPAllowed(Player player, Location location) {
        if (!this.enabled || this.api == null || location == null || !CompatibilityLib.getCompatibilityUtils().isChunkLoaded(location)) {
            return true;
        }
        return this.api.isPVPAllowed(player, location);
    }

    @Override
    public boolean hasBuildPermission(Player player, Block block) {
        if (!this.enabled || block == null || this.api == null) {
            return true;
        }
        return this.api.hasBuildPermission(player, block);
    }

    @Override
    @Nullable
    public Boolean getPersonalCastPermission(Player player, SpellTemplate spell, Location location) {
        if (!(this.override && this.enabled && this.api != null && location != null && CompatibilityLib.getCompatibilityUtils().isChunkLoaded(location))) {
            return null;
        }
        return this.api.getCastPermission(player, spell, location);
    }

    @Override
    public boolean hasBreakPermission(Player player, Block block) {
        return this.hasBuildPermission(player, block);
    }

    @Override
    public boolean canTarget(Entity source, Entity target) {
        if (!this.enabled || target == null || this.api == null) {
            return true;
        }
        return this.api.canTarget(source, target);
    }

    public boolean createField(Location location, Player player) {
        if (!this.enabled || this.api == null || location == null || player == null) {
            return false;
        }
        return this.api.createField(location, player);
    }

    public boolean rentField(Location signLocation, Player player, String rent, String timePeriod, BlockFace signDirection) {
        if (!this.enabled || this.api == null || signLocation == null || player == null) {
            return false;
        }
        return this.api.rentField(signLocation, player, rent, timePeriod, signDirection);
    }

    @Nullable
    @Deprecated
    public Map<String, Location> getFieldLocations(Player player) {
        if (!this.enabled || this.api == null || player == null) {
            return null;
        }
        List<PlayerWarp> warps = this.api.getFieldLocations(player);
        if (warps == null) {
            return null;
        }
        HashMap<String, Location> locations = new HashMap<String, Location>();
        for (PlayerWarp warp : warps) {
            locations.put(warp.getName(), warp.getLocation());
        }
        return locations;
    }

    @Override
    @Nullable
    public Collection<PlayerWarp> getWarps(@Nonnull Player player) {
        if (!this.enabled || this.api == null) {
            return null;
        }
        return this.api.getFieldLocations(player);
    }

    @Override
    @Nullable
    public Collection<PlayerWarp> getAllWarps() {
        if (!this.enabled || this.api == null) {
            return null;
        }
        return this.api.getAllFieldLocations();
    }
}

