/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.materials;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.MaterialMap;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.materials.NegatedMaterialSet;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class SimpleMaterialMap
implements MaterialMap {
    @Nonnull
    private final Map<Material, ? extends MaterialAndData> materials;
    private transient MaterialSet inverse;

    public SimpleMaterialMap(Map<Material, ? extends MaterialAndData> materialMap) {
        this.materials = materialMap;
    }

    @Override
    public MaterialAndData get(Material key) {
        return this.materials.get(key);
    }

    @Override
    public MaterialSet not() {
        if (this.inverse != null) {
            return this.inverse;
        }
        this.inverse = new NegatedMaterialSet(this);
        return this.inverse;
    }

    @Override
    public Collection<Material> getMaterials() {
        return this.materials.keySet();
    }

    @Override
    public boolean testMaterial(Material material) {
        return this.materials.containsKey(material);
    }

    @Override
    public boolean testBlock(Block testBlock) {
        return this.testMaterial(testBlock.getType());
    }

    @Override
    public boolean testItem(ItemStack item) {
        return this.testMaterial(item.getType());
    }

    @Override
    public boolean testMaterialAndData(MaterialAndData targetMaterial) {
        return this.testMaterial(targetMaterial.getMaterial());
    }
}

