/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.maps;

import com.elmakers.mine.bukkit.maps.MapController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ProfileCallback;
import com.elmakers.mine.bukkit.utility.ProfileResponse;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class URLMap
extends MapRenderer
implements com.elmakers.mine.bukkit.api.maps.URLMap {
    private static final Map<String, Collection<BufferedImage>> imageCache = new WeakHashMap<String, Collection<BufferedImage>>();
    private final MapController controller;
    private List<BufferedImage> frames = null;
    private List<Long> frameTimes = null;
    private int frame = 0;
    private boolean animated = false;
    private long lastFrameChange = 0L;
    protected String world;
    protected Integer id;
    protected String url;
    protected String playerName;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean isSlice;
    protected Integer xOverlay;
    protected Integer yOverlay;
    protected String name;
    protected boolean enabled = true;
    protected boolean rendered = false;
    protected volatile boolean loading = false;
    protected Set<String> sentToPlayers = new HashSet<String>();
    protected Integer priority;

    private Collection<BufferedImage> getImages(String url, MapController controller) throws IOException {
        Plugin plugin = controller.getPlugin();
        File cacheFolder = controller.getCacheFolder();
        Collection<BufferedImage> images = null;
        if (!url.startsWith("http")) {
            File fileName;
            if (!url.startsWith("/")) {
                File baseFolder = plugin.getDataFolder().getParentFile().getParentFile();
                fileName = new File(baseFolder, url);
            } else {
                fileName = new File(url);
            }
            controller.info("Loading map file: " + fileName.getName());
            images = this.loadImages(ImageIO.createImageInputStream(fileName));
        } else {
            File cacheFile;
            String cacheFileName = URLEncoder.encode(url, "UTF-8");
            File file = cacheFile = cacheFolder != null ? new File(cacheFolder, cacheFileName) : null;
            if (cacheFile != null) {
                if (cacheFile.exists()) {
                    controller.info("Loading from cache: " + cacheFile.getName());
                    images = this.loadImages(ImageIO.createImageInputStream(cacheFile));
                } else {
                    controller.info("Loading " + url);
                    URL imageUrl = new URL(url);
                    HttpURLConnection conn = (HttpURLConnection)imageUrl.openConnection();
                    conn.setConnectTimeout(30000);
                    conn.setReadTimeout(30000);
                    conn.setInstanceFollowRedirects(true);
                    try (InputStream in = conn.getInputStream();
                         FileOutputStream out = new FileOutputStream(cacheFile);){
                        int len;
                        byte[] buffer = new byte[10240];
                        while ((len = in.read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, len);
                        }
                    }
                    images = this.loadImages(ImageIO.createImageInputStream(cacheFile));
                }
            } else {
                controller.info("Loading " + url);
                URL imageUrl = new URL(url);
                images = this.loadImages(ImageIO.createImageInputStream(imageUrl));
            }
        }
        return images;
    }

    protected URLMap(MapController controller, String world, int mapId, String url, String name, int x, int y, Integer xOverlay, Integer yOverlay, int width, int height, Integer priority, String playerName, boolean isSlice) {
        this.controller = controller;
        this.world = world;
        this.url = url;
        this.name = name;
        this.x = x;
        this.y = y;
        this.xOverlay = xOverlay;
        this.yOverlay = yOverlay;
        this.width = width;
        this.height = height;
        this.id = mapId;
        this.priority = priority;
        this.playerName = playerName;
        this.isSlice = isSlice;
    }

    public void render(MapView mapView, MapCanvas canvas, Player player) {
        long delay;
        long now;
        if (this.animated && this.frameTimes != null && this.frameTimes.size() > 0 && this.controller.isAnimationAllowed() && (now = System.currentTimeMillis()) > this.lastFrameChange + (delay = this.frameTimes.get(this.frame).longValue())) {
            this.frame = (this.frame + 1) % this.frameTimes.size();
            this.sentToPlayers.clear();
            this.rendered = false;
            this.lastFrameChange = now;
        }
        if (this.rendered) {
            if (this.priority != null && player != null) {
                this.sendToPlayer(player, mapView);
            }
            return;
        }
        BufferedImage image = this.getImage();
        if (image != null) {
            canvas.drawImage(0, 0, (Image)image);
            this.rendered = true;
        }
    }

    public void initialize(MapView mapView) {
        this.rendered = false;
    }

    @Override
    public boolean matches(String keyword) {
        if (keyword == null || keyword.length() == 0) {
            return true;
        }
        String lowerUrl = this.url == null ? "" : this.url.toLowerCase();
        String lowerName = this.name == null ? "" : this.name.toLowerCase();
        String lowerKeyword = keyword.toLowerCase();
        return lowerUrl.contains(lowerKeyword) || lowerName.contains(lowerKeyword);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean fix(World world, int maxIds) {
        if (this.enabled) {
            return true;
        }
        MapView mapView = CompatibilityLib.getDeprecatedUtils().getMap(this.id);
        if (mapView != null) {
            this.enabled = true;
            return true;
        }
        boolean matched = false;
        for (int retry = 0; !matched && retry < maxIds; ++retry) {
            MapView newView = Bukkit.createMap((World)world);
            short newId = CompatibilityLib.getDeprecatedUtils().getMapId(newView);
            boolean bl = matched = newId == this.id;
            if (newId < 0 || newId > this.id) break;
        }
        if ((mapView = this.getMapView()) == null) {
            this.controller.warning("Failed to fix map id " + this.id + " for key " + this.getKey());
        } else {
            this.enabled = true;
        }
        return this.enabled;
    }

    @Nullable
    protected MapView getMapView() {
        if (!this.enabled) {
            return null;
        }
        MapView mapView = CompatibilityLib.getDeprecatedUtils().getMap(this.id);
        if (mapView == null) {
            this.enabled = false;
            this.controller.warning("Failed to get map id " + this.id + " for key " + this.getKey() + ", disabled, use 'mmap fix' to re-enable");
            return null;
        }
        List renderers = mapView.getRenderers();
        boolean needsRenderer = false;
        for (MapRenderer renderer : renderers) {
            if (renderer instanceof URLMap) continue;
            mapView.removeRenderer(renderer);
            needsRenderer = true;
        }
        if (needsRenderer) {
            mapView.addRenderer((MapRenderer)this);
        }
        return mapView;
    }

    protected void disable() {
        this.enabled = false;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    protected String getKey() {
        return URLMap.getKey(this.world, this.url, this.playerName, this.x, this.y, this.width, this.height, this.isSlice);
    }

    protected static String getKey(String world, String url, String playerName, int x, int y, int width, int height, boolean isSlice) {
        if (url == null) {
            url = playerName;
        }
        String key = world + "|" + x + "," + y + "|" + width + "," + height + "|" + url;
        if (isSlice) {
            key = "slice:" + key;
        }
        return key;
    }

    protected void resendTo(String playerName) {
        this.sentToPlayers.remove(playerName);
    }

    protected void reload() {
        this.sentToPlayers.clear();
        this.rendered = false;
        this.loading = false;
        this.frames = null;
    }

    protected Collection<BufferedImage> loadImages(ImageInputStream in) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        try {
            if (this.animated) {
                ImageReader reader = ImageIO.getImageReadersBySuffix("GIF").next();
                reader.setInput(in);
                this.frameTimes = new ArrayList<Long>();
                this.lastFrameChange = System.currentTimeMillis();
                this.loadGIFImages(reader, images);
                reader.dispose();
            } else {
                BufferedImage frame = ImageIO.read(in);
                if (frame != null) {
                    images.add(frame);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return images;
    }

    private void loadGIFImages(ImageReader reader, Collection<BufferedImage> images) throws IOException {
        IIOMetadataNode screenDescriptor;
        IIOMetadataNode globalRoot;
        NodeList globalScreenDescriptor;
        int width = -1;
        int height = -1;
        IIOMetadata metadata = reader.getStreamMetadata();
        if (metadata != null && (globalScreenDescriptor = (globalRoot = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName())).getElementsByTagName("LogicalScreenDescriptor")) != null && globalScreenDescriptor.getLength() > 0 && (screenDescriptor = (IIOMetadataNode)globalScreenDescriptor.item(0)) != null) {
            width = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenWidth"));
            height = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenHeight"));
        }
        BufferedImage master = null;
        Graphics2D masterGraphics = null;
        ArrayList<String> frameDisposals = new ArrayList<String>();
        int frameIndex = 0;
        while (true) {
            BufferedImage image;
            try {
                image = reader.read(frameIndex);
            }
            catch (IndexOutOfBoundsException io) {
                break;
            }
            if (image == null) break;
            if (width == -1 || height == -1) {
                width = image.getWidth();
                height = image.getHeight();
            }
            IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(frameIndex).getAsTree("javax_imageio_gif_image_1.0");
            IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
            int delay = Integer.parseInt(gce.getAttribute("delayTime"));
            String disposal = gce.getAttribute("disposalMethod");
            int x = 0;
            int y = 0;
            if (master == null) {
                master = new BufferedImage(width, height, 2);
                masterGraphics = master.createGraphics();
                masterGraphics.setBackground(new Color(0, 0, 0, 0));
            } else {
                NodeList children = root.getChildNodes();
                for (int nodeIndex = 0; nodeIndex < children.getLength(); ++nodeIndex) {
                    Node nodeItem = children.item(nodeIndex);
                    if (!nodeItem.getNodeName().equals("ImageDescriptor")) continue;
                    NamedNodeMap map = nodeItem.getAttributes();
                    x = Integer.parseInt(map.getNamedItem("imageLeftPosition").getNodeValue());
                    y = Integer.parseInt(map.getNamedItem("imageTopPosition").getNodeValue());
                }
            }
            masterGraphics.drawImage((Image)image, x, y, null);
            BufferedImage copy = new BufferedImage(master.getColorModel(), master.copyData(null), master.isAlphaPremultiplied(), null);
            images.add(copy);
            this.frameTimes.add(10L * (long)delay);
            frameDisposals.add(disposal);
            if (disposal.equals("restoreToPrevious")) {
                BufferedImage from = null;
                for (int i = frameIndex - 1; i >= 0; --i) {
                    if (((String)frameDisposals.get(i)).equals("restoreToPrevious") && frameIndex != 0) continue;
                    from = this.frames.get(i);
                    break;
                }
                if (from == null) break;
                master = new BufferedImage(from.getColorModel(), from.copyData(null), from.isAlphaPremultiplied(), null);
                masterGraphics = master.createGraphics();
                masterGraphics.setBackground(new Color(0, 0, 0, 0));
            } else if (disposal.equals("restoreToBackgroundColor")) {
                masterGraphics.clearRect(x, y, image.getWidth(), image.getHeight());
            }
            ++frameIndex;
        }
    }

    @Nullable
    protected BufferedImage getImage() {
        if (this.loading || !this.enabled) {
            return null;
        }
        if (this.url == null) {
            if (this.playerName != null) {
                this.loading = true;
                CompatibilityLib.getSkinUtils().fetchProfile(this.playerName, new ProfileCallback(){

                    @Override
                    public void result(ProfileResponse response) {
                        String string = URLMap.this.url = response == null ? null : response.getSkinURL();
                        if (URLMap.this.url == null) {
                            URLMap.this.enabled = false;
                        }
                        URLMap.this.controller.save();
                        URLMap.this.loading = false;
                    }
                });
            }
            return null;
        }
        if (this.frames == null) {
            this.loading = true;
            this.frames = new ArrayList<BufferedImage>();
            Plugin plugin = this.controller.getPlugin();
            if (plugin == null) {
                return null;
            }
            Bukkit.getScheduler().runTaskAsynchronously(plugin, (Runnable)new GetImageTask());
            return null;
        }
        return this.frames.get(this.frame);
    }

    protected void reset() {
        this.frames = null;
        this.rendered = false;
        this.loading = false;
        this.sentToPlayers.clear();
    }

    protected void sendToPlayer(Player player, MapView mapView) {
        if (this.priority == null || !this.enabled) {
            return;
        }
        String playerName = player.getName();
        if (!this.sentToPlayers.contains(playerName) && Math.random() * (double)this.priority.intValue() <= 1.0) {
            this.sentToPlayers.add(playerName);
            player.sendMap(mapView);
        }
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Override
    public boolean isSlice() {
        return this.isSlice;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    private class GetImageTask
    implements Runnable {
        private GetImageTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Collection images;
                URLMap.this.animated = URLMap.this.url.endsWith(".gif");
                Map map = imageCache;
                synchronized (map) {
                    images = (Collection)imageCache.get(URLMap.this.url);
                    if (images == null) {
                        images = URLMap.this.getImages(URLMap.this.url, URLMap.this.controller);
                        imageCache.put(URLMap.this.url, images);
                    }
                }
                if (images.size() == 0) {
                    URLMap.this.enabled = false;
                    URLMap.this.controller.warning("Failed to load map " + URLMap.this.url);
                }
                for (BufferedImage rawImage : images) {
                    int imageY;
                    int imageX;
                    int imageHeight;
                    int imageWidth;
                    if (URLMap.this.isSlice && URLMap.this.width > 0 && URLMap.this.height > 0) {
                        imageWidth = rawImage.getWidth() / URLMap.this.width;
                        imageHeight = rawImage.getHeight() / URLMap.this.height;
                        imageX = URLMap.this.x * imageWidth;
                        imageY = URLMap.this.y * imageHeight;
                    } else {
                        imageWidth = URLMap.this.width <= 0 ? rawImage.getWidth() + URLMap.this.width : URLMap.this.width;
                        imageHeight = URLMap.this.height <= 0 ? rawImage.getHeight() + URLMap.this.height : URLMap.this.height;
                        imageX = URLMap.this.x;
                        imageY = URLMap.this.y;
                    }
                    if (imageWidth > rawImage.getWidth()) {
                        imageWidth = rawImage.getWidth();
                    }
                    if (imageHeight > rawImage.getHeight()) {
                        imageHeight = rawImage.getHeight();
                    }
                    BufferedImage croppedImage = rawImage.getSubimage(imageX += rawImage.getMinX(), imageY += rawImage.getMinY(), imageWidth, imageHeight);
                    BufferedImage image = new BufferedImage(128, 128, 2);
                    Graphics2D graphics = image.createGraphics();
                    AffineTransform transform = AffineTransform.getScaleInstance(128.0f / (float)imageWidth, 128.0f / (float)imageHeight);
                    graphics.drawRenderedImage(croppedImage, transform);
                    if (URLMap.this.xOverlay != null && URLMap.this.yOverlay != null) {
                        BufferedImage croppedOverlay = rawImage.getSubimage(URLMap.this.xOverlay, URLMap.this.yOverlay, imageWidth, imageHeight);
                        graphics.drawRenderedImage(croppedOverlay, transform);
                    }
                    URLMap.this.frames.add(image);
                }
                URLMap.this.loading = false;
            }
            catch (Exception ex) {
                URLMap.this.controller.warning("Failed to load map " + URLMap.this.url + ": " + ex.getMessage());
            }
        }
    }
}

