/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command.config;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.config.ApplySessionCallback;
import com.elmakers.mine.bukkit.magic.command.config.GetSessionRequest;
import com.elmakers.mine.bukkit.magic.command.config.GetSessionResponse;
import com.elmakers.mine.bukkit.magic.command.config.HttpPost;
import com.elmakers.mine.bukkit.magic.command.config.Session;
import com.google.gson.Gson;
import org.bukkit.command.CommandSender;

public class GetSessionRunnable
extends HttpPost {
    private final ApplySessionCallback successCallback;

    public GetSessionRunnable(MagicController controller, Gson gson, CommandSender sender, GetSessionRequest request, ApplySessionCallback successCallback) {
        super(controller, gson, sender, gson.toJson((Object)request), controller.getEditorURL() + "/session/get");
        this.successCallback = successCallback;
    }

    @Override
    public void processResponse(String response) {
        GetSessionResponse getSessionResponse = (GetSessionResponse)this.gson.fromJson(response, GetSessionResponse.class);
        if (!getSessionResponse.isSuccess()) {
            this.fail(this.controller.getMessages().get("commands.mconfig.editor.server_error").replace("$message", getSessionResponse.getMessage()));
        } else {
            Session session = getSessionResponse.getSession();
            if (session == null) {
                this.fail("Missing session in response");
                return;
            }
            if (this.successCallback != null) {
                this.successCallback.success(session);
            }
        }
    }
}

