/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command.config;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class AsyncProcessor {
    public static void success(MageController controller, CommandSender sender, String message) {
        AsyncProcessor.message(controller, sender, message);
    }

    public static void message(final MageController controller, final CommandSender sender, final String message) {
        Plugin plugin = controller.getPlugin();
        plugin.getServer().getScheduler().runTask(plugin, new Runnable(){

            @Override
            public void run() {
                Mage mage = controller.getMage(sender);
                mage.sendMessage(message);
            }
        });
    }

    public static void fail(MageController controller, CommandSender sender, String message) {
        AsyncProcessor.fail(controller, sender, message, null, null);
    }

    public static void fail(final MageController controller, final CommandSender sender, final String message, final String errorMessage, final Exception ex) {
        Plugin plugin = controller.getPlugin();
        plugin.getServer().getScheduler().runTask(plugin, new Runnable(){

            @Override
            public void run() {
                Mage mage = controller.getMage(sender);
                mage.sendMessage(ChatColor.RED + message);
                if (errorMessage != null) {
                    controller.getLogger().log(Level.WARNING, errorMessage, ex);
                }
            }
        });
    }
}

