/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class TriggerCommandExecutor
extends MagicTabExecutor {
    public TriggerCommandExecutor(MagicAPI api) {
        super(api, "mtrigger");
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        return new ArrayList<String>();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Mage targetMage;
        if (!this.api.hasPermission(sender, this.getPermissionNode())) {
            this.sendNoPermission(sender);
            return true;
        }
        Messages messages = this.controller.getMessages();
        Mage mage = this.controller.getMage(sender);
        if (args.length != 2) {
            mage.sendMessage(messages.get("commands.mtrigger.invalid_parameters"));
            return true;
        }
        String mageId = args[0];
        String triggerId = args[1];
        if (!this.api.hasPermission(sender, "magic.mtrigger")) {
            try {
                UUID.fromString(triggerId);
            }
            catch (IllegalArgumentException invalidUUID) {
                mage.sendMessage(messages.get("commands.mtrigger.invalid_target"));
                return true;
            }
        }
        if ((targetMage = this.api.getController().getRegisteredMage(mageId)) == null) {
            mage.sendMessage(messages.get("commands.mtrigger.no_mage"));
            return true;
        }
        targetMage.trigger(triggerId);
        return true;
    }
}

