/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class MagicServerCommandExecutor
extends MagicTabExecutor {
    public MagicServerCommandExecutor(MagicAPI api) {
        super(api, "mserver");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        List<Entity> targets;
        String server;
        Player player;
        if (args.length < 1) {
            return false;
        }
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (args.length < 2) {
            if (player == null) {
                return false;
            }
            server = args[0];
            targets = new ArrayList<Entity>();
            targets.add((Entity)player);
        } else {
            Player findPlayer;
            targets = CompatibilityLib.getCompatibilityUtils().selectEntities(sender, args[0]);
            if (targets == null && (findPlayer = CompatibilityLib.getDeprecatedUtils().getPlayer(args[0])) != null) {
                targets = new ArrayList<Entity>();
                targets.add((Entity)findPlayer);
            }
            server = args[1];
        }
        if (targets == null || targets.isEmpty()) {
            sender.sendMessage("No targets founds");
            return true;
        }
        for (Entity entity : targets) {
            if (!(entity instanceof Player)) continue;
            this.api.getController().sendPlayerToServer((Player)entity, server);
        }
        return true;
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        ArrayList<String> options = new ArrayList<String>();
        if (!sender.hasPermission("magic.commands.mserver")) {
            return options;
        }
        if (args.length == 1) {
            options.addAll(this.api.getPlayerNames());
        }
        return options;
    }
}

