/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.configuration.MageParameters;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.TemplateProperties;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.google.common.base.Preconditions;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;

public class MageClassTemplate
extends TemplateProperties
implements com.elmakers.mine.bukkit.api.magic.MageClassTemplate {
    private MageClassTemplate parent;
    private boolean isLocked = false;
    private String name;
    private String description;

    public MageClassTemplate(@Nonnull MageController controller, @Nonnull String key, @Nonnull ConfigurationSection configuration) {
        super(controller, key, configuration);
        Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
        this.isLocked = this.getProperty("locked", false);
        this.clearProperty("locked");
        this.clearProperty("parent");
        this.clearProperty("path_start");
        this.clearProperty("hidden");
        this.clearProperty("enabled");
        this.clearProperty("inherit");
        this.name = controller.getMessages().get("classes." + key + ".name", key);
        this.description = controller.getMessages().get("classes." + key + ".description", "");
        this.name = configuration.getString("name", this.name);
        this.description = configuration.getString("description", this.description);
    }

    private MageClassTemplate(MageClassTemplate copy, ConfigurationSection configuration) {
        super(copy.controller, copy.getKey(), configuration);
        this.isLocked = copy.isLocked;
        this.name = copy.name;
        this.description = copy.description;
        this.parent = copy.parent;
    }

    public MageClassTemplate getMageTemplate(Mage mage) {
        MageParameters parameters = new MageParameters(mage, "Mage class " + this.getKey());
        ConfigurationUtils.addConfigurations((ConfigurationSection)parameters, this.configuration);
        return new MageClassTemplate(this, (ConfigurationSection)parameters);
    }

    @Override
    @Nullable
    public MageClassTemplate getParent() {
        return this.parent;
    }

    public void setParent(@Nullable MageClassTemplate parent) {
        this.parent = parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public boolean isLocked() {
        if (this.isLocked) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.isLocked();
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Collection<String> getRecipies() {
        return this.getStringList("craftable");
    }
}

