/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Trigger;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import com.elmakers.mine.bukkit.utility.random.WeightedPair;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class CustomTrigger
extends Trigger {
    protected Deque<WeightedPair<SpellCast>> spells;
    protected Collection<EffectPlayer> effects;
    protected List<String> commands;

    public CustomTrigger(@Nonnull MageController controller, @Nonnull String key, @Nonnull ConfigurationSection configuration) {
        super(controller, configuration, key);
        List checkList;
        if (configuration.isString("cast")) {
            String castCommand = configuration.getString("cast");
            if (!castCommand.isEmpty()) {
                this.spells = new ArrayDeque<WeightedPair<SpellCast>>();
                String[] pieces = StringUtils.split((String)castCommand, (String)" ");
                String spellKey = pieces[0];
                ConfigurationSection parameters = null;
                if (pieces.length > 1) {
                    String[] castParameters = Arrays.copyOfRange(pieces, 1, pieces.length);
                    parameters = ConfigurationUtils.newConfigurationSection();
                    ConfigurationUtils.addParameters(castParameters, parameters);
                }
                this.spells.add(new WeightedPair<SpellCast>(new SpellCast(spellKey, parameters)));
            }
        } else if (configuration.isConfigurationSection("cast")) {
            ArrayDeque<WeightedPair<String>> spellKeys = new ArrayDeque<WeightedPair<String>>();
            this.spells = new ArrayDeque<WeightedPair<SpellCast>>();
            RandomUtils.populateStringProbabilityMap(spellKeys, configuration, "cast");
            for (WeightedPair<String> spellKey : spellKeys) {
                this.spells.add(new WeightedPair<SpellCast>(spellKey, new SpellCast(spellKey.getValue())));
            }
        } else if (configuration.isList("cast") && !(checkList = configuration.getList("cast")).isEmpty()) {
            Object first = checkList.get(0);
            if (first instanceof String) {
                List stringList = checkList;
                this.spells = new ArrayDeque<WeightedPair<SpellCast>>();
                ArrayDeque<WeightedPair<String>> spellKeys = new ArrayDeque<WeightedPair<String>>();
                RandomUtils.populateStringProbabilityList(spellKeys, stringList);
                for (WeightedPair<String> spellKey : spellKeys) {
                    this.spells.add(new WeightedPair<SpellCast>(spellKey, new SpellCast(spellKey.getValue())));
                }
            } else if (first instanceof ConfigurationSection || first instanceof Map) {
                float currentThreshold = 0.0f;
                this.spells = new ArrayDeque<WeightedPair<SpellCast>>();
                for (Object configGeneric : checkList) {
                    ConfigurationSection config = null;
                    if (configGeneric instanceof ConfigurationSection) {
                        config = (ConfigurationSection)configGeneric;
                    }
                    if (configGeneric instanceof Map) {
                        Map configMap = (Map)configGeneric;
                        config = ConfigurationUtils.toConfigurationSection(configuration, configMap);
                    }
                    if (config == null) continue;
                    String spellKey = config.getString("spell");
                    if (spellKey == null || spellKey.isEmpty()) {
                        controller.getLogger().warning("Trigger spell config missing 'spell' key");
                        continue;
                    }
                    config.set("spell", null);
                    this.spells.add(new WeightedPair<SpellCast>(Float.valueOf(currentThreshold += (float)config.getDouble("probability", 1.0)), new SpellCast(spellKey, config)));
                }
            }
        }
        this.commands = ConfigurationUtils.getStringList(configuration, "commands");
        if (configuration.contains("effects")) {
            this.effects = controller.loadEffects(configuration, "effects");
        }
    }

    protected boolean cast(Mage mage, String castSpell, ConfigurationSection parameters) {
        if (castSpell.isEmpty() || castSpell.equalsIgnoreCase("none")) {
            return false;
        }
        if (parameters != null) {
            parameters = ConfigurationUtils.cloneConfiguration(parameters);
        }
        MageSpell spell = null;
        if (castSpell.contains(" ")) {
            String[] additionalParameters = StringUtils.split((String)castSpell, (char)' ');
            castSpell = additionalParameters[0];
            additionalParameters = Arrays.copyOfRange(additionalParameters, 1, additionalParameters.length);
            if (parameters == null) {
                parameters = ConfigurationUtils.newConfigurationSection();
            }
            ConfigurationUtils.addParameters(additionalParameters, parameters);
        }
        if ((spell = mage.getSpell(castSpell)) == null) {
            mage.getController().getLogger().warning("Unknown spell in trigger: " + castSpell + " from " + mage.getName());
            return false;
        }
        double bowpull = mage.getLastBowPull();
        if (bowpull > 0.0) {
            if (parameters == null) {
                parameters = ConfigurationUtils.newConfigurationSection();
            }
            parameters.set("bowpull", (Object)Double.toString(bowpull));
        }
        return spell.cast(parameters);
    }

    public boolean cancel(Mage mage) {
        if (!this.isValid(mage)) {
            return false;
        }
        if (this.effects != null) {
            for (EffectPlayer effectPlayer : this.effects) {
                effectPlayer.cancel();
            }
        }
        if (this.spells != null && !this.spells.isEmpty()) {
            for (WeightedPair weightedPair : this.spells) {
                mage.cancelPending(((SpellCast)weightedPair.getValue()).spell);
            }
        }
        return true;
    }

    public boolean execute(Mage mage) {
        if (!this.isValid(mage)) {
            return false;
        }
        this.triggered();
        if (this.effects != null) {
            for (EffectPlayer player : this.effects) {
                player.start(mage.getContext());
            }
        }
        if (this.spells != null && !this.spells.isEmpty()) {
            SpellCast spellCast = (SpellCast)RandomUtils.weightedRandom(this.spells);
            this.cast(mage, spellCast.spell, spellCast.parameters);
        }
        if (this.commands != null) {
            Entity topDamager = mage.getTopDamager();
            Entity killer = mage.getLastDamager();
            Collection<Entity> damagers = mage.getDamagers();
            Location location = mage.getLocation();
            for (String command : this.commands) {
                boolean allDamagers;
                if (command.contains("@killer")) {
                    if (killer == null) continue;
                    command = command.replace("@killer", killer.getName());
                }
                if ((allDamagers = command.contains("@damagers")) && damagers == null) continue;
                if (!allDamagers && command.contains("@damager")) {
                    if (topDamager == null) continue;
                    command = command.replace("@damager", topDamager.getName());
                }
                command = command.replace("@name", mage.getName()).replace("@world", location.getWorld().getName()).replace("@x", Double.toString(location.getX())).replace("@y", Double.toString(location.getY())).replace("@z", Double.toString(location.getZ()));
                if (allDamagers) {
                    for (Entity damager : damagers) {
                        String damagerCommand = command.replace("@damagers", damager.getName());
                        mage.getController().getPlugin().getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), damagerCommand);
                    }
                    continue;
                }
                mage.getController().getPlugin().getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command);
            }
        }
        return true;
    }

    protected static class SpellCast {
        public final String spell;
        public final ConfigurationSection parameters;

        public SpellCast(String spell, ConfigurationSection parameters) {
            this.spell = spell;
            this.parameters = parameters;
        }

        public SpellCast(String spell) {
            this(spell, null);
        }
    }
}

