/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.kit;

import com.elmakers.mine.bukkit.kit.GivenItem;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class MageKit {
    private final String key;
    private long lastGive;
    private long lastTook;
    private final Map<String, GivenItem> givenItems = new HashMap<String, GivenItem>();

    public MageKit(String kitKey) {
        this.key = kitKey;
    }

    public void gave(String itemKey, int itemAmount) {
        this.lastGive = System.currentTimeMillis();
        GivenItem given = this.givenItems.get(itemKey);
        if (given == null) {
            given = new GivenItem(itemKey);
            this.givenItems.put(itemKey, given);
        }
        given.add(itemAmount);
    }

    public void took(String itemKey) {
        this.lastTook = System.currentTimeMillis();
        GivenItem given = this.givenItems.get(itemKey);
        if (given == null) {
            given = new GivenItem(itemKey);
            this.givenItems.put(itemKey, given);
        }
        given.took();
    }

    public long getLastGiveTime() {
        return this.lastGive;
    }

    public long getLastTookTime() {
        return this.lastTook;
    }

    public int getGivenAmount(String itemKey) {
        GivenItem item = this.givenItems.get(itemKey);
        return item == null ? 0 : item.getAmount();
    }

    public static MageKit load(String key, ConfigurationSection kitConfig) {
        MageKit kit = new MageKit(key);
        kit.lastGive = kitConfig.getLong("last_give");
        kit.lastTook = kitConfig.getLong("last_took");
        ConfigurationSection items = kitConfig.getConfigurationSection("given_items");
        if (items != null) {
            for (String itemKey : items.getKeys(false)) {
                kit.givenItems.put(itemKey, new GivenItem(itemKey, items.getConfigurationSection(itemKey)));
            }
        }
        return kit;
    }

    public void saveTo(ConfigurationSection kitConfig) {
        ConfigurationSection kitSection = kitConfig.createSection(this.key);
        this.save(kitSection);
    }

    public void save(ConfigurationSection kitConfig) {
        if (this.lastGive > 0L) {
            kitConfig.set("last_give", (Object)this.lastGive);
        }
        if (this.lastTook > 0L) {
            kitConfig.set("last_took", (Object)this.lastTook);
        }
        if (!this.givenItems.isEmpty()) {
            ConfigurationSection givenSection = kitConfig.createSection("given_items");
            for (GivenItem item : this.givenItems.values()) {
                item.saveTo(givenSection);
            }
        }
    }
}

