/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.kit;

import org.bukkit.configuration.ConfigurationSection;

public class GivenItem {
    private final String itemKey;
    private int amount;
    private long lastGive;
    private long lastTook;

    public GivenItem(String itemKey) {
        this.itemKey = itemKey;
    }

    public GivenItem(String itemKey, ConfigurationSection config) {
        this.itemKey = itemKey;
        if (config != null) {
            this.amount = config.getInt("amount");
            this.lastGive = config.getLong("last_give");
            this.lastTook = config.getLong("last_took");
        }
    }

    public void took() {
        this.lastTook = System.currentTimeMillis();
    }

    public void add(int amount) {
        this.amount += amount;
        this.lastGive = System.currentTimeMillis();
    }

    public void saveTo(ConfigurationSection config) {
        ConfigurationSection section = config.createSection(this.itemKey);
        section.set("amount", (Object)this.amount);
        if (this.lastGive > 0L) {
            section.set("last_give", (Object)this.lastGive);
        }
        if (this.lastTook > 0L) {
            section.set("last_took", (Object)this.lastTook);
        }
    }

    public int getAmount() {
        return this.amount;
    }
}

