/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.item;

import com.elmakers.mine.bukkit.item.AttributeOperation;
import com.elmakers.mine.bukkit.item.InventorySlot;
import org.bukkit.configuration.ConfigurationSection;

public class MagicAttributeModifier {
    private final String attribute;
    private final AttributeOperation operation;
    private final double value;
    private final InventorySlot slot;

    public MagicAttributeModifier(String attributeKey, double value) {
        this.attribute = attributeKey;
        this.value = value;
        this.slot = InventorySlot.FREE;
        this.operation = AttributeOperation.DEFAULT;
    }

    public MagicAttributeModifier(String attributeKey, ConfigurationSection config, double defaultValue) {
        this.attribute = config.getString("attribute", attributeKey);
        this.value = config.getDouble("value", defaultValue);
        String operationString = config.getString("operation");
        this.operation = operationString != null && !operationString.isEmpty() ? AttributeOperation.parse(operationString) : AttributeOperation.DEFAULT;
        String slotString = config.getString("slot");
        this.slot = slotString != null && !slotString.isEmpty() ? InventorySlot.parse(slotString) : InventorySlot.FREE;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public AttributeOperation getOperation() {
        return this.operation;
    }

    public double getValue() {
        return this.value;
    }

    public InventorySlot getSlot() {
        return this.slot;
    }
}

