/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Is Class")
@Description(value={"Checks whether a player is a magic class."})
@Examples(value={"player is class \"mage\"", "player is not class \"jedi\""})
public class CondIsClass
extends Condition {
    private Expression<Entity> entities;
    private Expression<String> classes;

    public static void register() {
        Skript.registerCondition(CondIsClass.class, (String[])new String[]{"%entities% (is|are) class[es] %strings%", "%entities% (isn't|is not|aren't|are not) class[es] %strings%"});
    }

    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = vars[0];
        this.classes = vars[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(final Event e) {
        return this.entities.check(e, (Checker)new Checker<Entity>(){

            public boolean check(Entity entity) {
                final Mage mage = MagicPlugin.getAPI().getController().getRegisteredMage(entity);
                if (mage == null) {
                    return false;
                }
                return CondIsClass.this.classes.check(e, (Checker)new Checker<String>(){

                    public boolean check(String className) {
                        return mage.hasClassUnlocked(className);
                    }
                }, CondIsClass.this.isNegated());
            }
        });
    }

    public String toString(@Nullable Event e, boolean debug) {
        return this.entities.toString(e, debug) + (this.entities.isSingle() ? " is" : " are") + (this.isNegated() ? " not" : "") + " class " + this.classes;
    }
}

