/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import com.elmakers.mine.bukkit.integration.MythicMobManager;
import com.elmakers.mine.bukkit.magic.MagicController;
import io.lumine.mythic.api.MythicPlugin;
import io.lumine.mythic.api.mobs.MobManager;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class ModernMythicMobManager
implements MythicMobManager {
    private final MagicController controller;
    private final Plugin plugin;
    private MythicPlugin api = null;

    public ModernMythicMobManager(MagicController controller, Plugin plugin) {
        this.controller = controller;
        this.plugin = plugin;
    }

    @Override
    public boolean initialize() {
        if (this.plugin == null || !(this.plugin instanceof MythicPlugin)) {
            return false;
        }
        this.api = (MythicPlugin)this.plugin;
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.api != null;
    }

    @Override
    @Nullable
    public Entity spawn(String key, Location location, double level) {
        if (this.api == null) {
            return null;
        }
        Optional mythicMob = this.api.getMobManager().getMythicMob(key);
        if (!mythicMob.isPresent()) {
            this.controller.getLogger().warning("Unknown mythic mob type: " + key);
            return null;
        }
        ActiveMob mob = ((MythicMob)mythicMob.get()).spawn(BukkitAdapter.adapt((Location)location), level);
        if (mob == null) {
            this.controller.getLogger().warning("Unable to spawn mythic mob with id of " + key);
            return null;
        }
        return mob.getEntity().getBukkitEntity();
    }

    @Override
    public Collection<String> getMobKeys() {
        if (this.api == null) {
            return null;
        }
        return this.api.getMobManager().getMobNames();
    }

    @Override
    public boolean isMobKey(String mobKey) {
        if (this.api == null) {
            return false;
        }
        return this.api.getMobManager().getMobNames().contains(mobKey);
    }

    @Override
    public void setMobLevel(Entity entity, double level) {
        if (this.api == null || entity == null) {
            return;
        }
        Optional<ActiveMob> mob = this.getActiveMob(entity.getUniqueId());
        if (!mob.isPresent()) {
            return;
        }
        mob.get().setLevel(level);
    }

    @Override
    @Nullable
    public Double getMobLevel(Entity entity) {
        if (this.api == null || entity == null) {
            return null;
        }
        Optional<ActiveMob> mob = this.getActiveMob(entity.getUniqueId());
        if (!mob.isPresent()) {
            return null;
        }
        return mob.get().getLevel();
    }

    @Override
    @Nullable
    public String getMobKey(Entity entity) {
        if (this.api == null || entity == null) {
            return null;
        }
        Optional<ActiveMob> mob = this.getActiveMob(entity.getUniqueId());
        if (!mob.isPresent()) {
            return null;
        }
        return mob.get().getMobType();
    }

    public Optional<ActiveMob> getActiveMob(UUID id) {
        try {
            MobManager manager = this.api.getMobManager();
            Method getActiveMobMethod = manager.getClass().getMethod("getActiveMob", UUID.class);
            if (getActiveMobMethod != null) {
                return (Optional)getActiveMobMethod.invoke((Object)manager, id);
            }
            this.controller.getLogger().warning("MythicMobs integration has gone wrong, disabling");
            this.api = null;
        }
        catch (Exception ex) {
            this.controller.getLogger().warning("MythicMobs integration has gone wrong, disabling");
            this.api = null;
        }
        return Optional.empty();
    }
}

