/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.heroes;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import java.util.Collection;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class HeroesSpellSkill
extends ActiveSkill {
    private final SpellTemplate spellTemplate;
    private final MageController controller;
    private final ConfigurationSection parameters = ConfigurationUtils.newConfigurationSection();
    private int spellLevel = 1;

    public HeroesSpellSkill(Heroes heroes, String spellKey) {
        super(heroes, HeroesSpellSkill.getSkillName(heroes, spellKey));
        Plugin magicPlugin = heroes.getServer().getPluginManager().getPlugin("Magic");
        MagicAPI api = (MagicAPI)magicPlugin;
        this.controller = api.getController();
        this.spellTemplate = this.controller.getSpellTemplate(spellKey);
        String skillKey = this.spellTemplate.getName().replace(" ", "");
        this.setDescription(this.spellTemplate.getDescription());
        this.setUsage("/skill " + skillKey);
        this.setArgumentRange(0, 0);
        this.setIdentifiers(new String[]{"skill " + skillKey});
    }

    private static String getSkillName(Heroes heroes, String spellKey) {
        Plugin magicPlugin = heroes.getServer().getPluginManager().getPlugin("Magic");
        if (magicPlugin == null || !(magicPlugin instanceof MagicAPI) && !magicPlugin.isEnabled()) {
            heroes.getLogger().warning("MagicHeroes skills require the Magic plugin");
            throw new RuntimeException("MagicHeroes skills require the Magic plugin");
        }
        MagicAPI api = (MagicAPI)magicPlugin;
        MageController controller = api.getController();
        ((MagicController)controller).checkPostStartupLoad();
        SpellTemplate spellTemplate = controller.getSpellTemplate(spellKey);
        if (spellTemplate == null) {
            controller.getLogger().warning("Failed to load Magic skill spell: " + spellKey);
            throw new RuntimeException("Failed to load Magic skill spell: " + spellKey);
        }
        String baseName = ChatColor.stripColor((String)spellTemplate.getName().replace(" ", ""));
        return controller.getHeroesSkillPrefix() + baseName;
    }

    public void init() {
        super.init();
        Set parameterKeys = this.parameters.getKeys(false);
        for (String parameterKey : parameterKeys) {
            String value = SkillConfigManager.getRaw((Skill)this, (String)parameterKey, null);
            this.parameters.set(parameterKey, (Object)value);
        }
        String spellLevelString = SkillConfigManager.getRaw((Skill)this, (String)"tier", null);
        if (spellLevelString != null && spellLevelString.isEmpty()) {
            try {
                this.spellLevel = Integer.parseInt(spellLevelString);
            }
            catch (NumberFormatException ex) {
                this.controller.getLogger().warning("Invalid tier in skill config for " + this.spellTemplate.getKey() + ": " + spellLevelString);
            }
        }
    }

    public SkillResult use(Hero hero, String[] strings) {
        MageSpell spell;
        Mage mage = this.controller.getMage(hero.getPlayer());
        boolean success = false;
        String spellKey = this.spellTemplate.getKey();
        int targetLevel = SkillConfigManager.getUseSetting((Hero)hero, (Skill)this, (String)"tier", (int)this.spellLevel, (boolean)true);
        if (targetLevel != 1) {
            SpellKey key = new SpellKey(this.spellTemplate.getSpellKey().getBaseKey(), targetLevel);
            spellKey = key.getKey();
        }
        if ((spell = mage.getSpell(spellKey)) == null) {
            if (targetLevel > 1) {
                this.controller.getLogger().warning("Invalid tier for spell in skills config: " + spellKey + " (tier " + this.spellLevel + ")");
            } else {
                this.controller.getLogger().warning("Invalid spell in skills config: " + spellKey);
            }
            return SkillResult.FAIL;
        }
        Set parameterKeys = this.parameters.getKeys(false);
        ConfigurationSection spellParameters = this.spellTemplate.getSpellParameters();
        ConfigurationSection heroParameters = ConfigurationUtils.newConfigurationSection();
        for (String parameterKey : parameterKeys) {
            String value = this.parameters.getString(parameterKey);
            String magicKey = this.heroesToMagic(parameterKey);
            Double doubleValue = null;
            try {
                doubleValue = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String magicValue = spellParameters.getString(magicKey);
            if (doubleValue != null) {
                doubleValue = SkillConfigManager.getUseSetting((Hero)hero, (Skill)this, (String)parameterKey, (double)doubleValue, (boolean)true);
                Double doubleMagicValue = null;
                try {
                    if (magicValue != null) {
                        doubleMagicValue = Double.parseDouble(magicValue.toString());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (doubleMagicValue != null && doubleValue.equals(doubleMagicValue)) {
                    continue;
                }
            } else {
                value = SkillConfigManager.getUseSetting((Hero)hero, (Skill)this, (String)parameterKey, (String)value);
                if (magicValue != null && value != null && value.equals(magicValue)) continue;
            }
            if (doubleValue != null) {
                heroParameters.set(magicKey, (Object)doubleValue);
                continue;
            }
            heroParameters.set(magicKey, (Object)value);
        }
        heroParameters.set("cost_reduction", (Object)2);
        heroParameters.set("cooldown_reduction", (Object)2);
        success = spell.cast(heroParameters);
        if (success) {
            this.broadcastExecuteText(hero);
        }
        return success ? SkillResult.NORMAL : SkillResult.FAIL;
    }

    public ConfigurationSection getDefaultConfig() {
        SpellKey upgradeKey;
        SpellTemplate upgrade;
        MaterialAndData disabledIcon;
        ConfigurationSection node = super.getDefaultConfig();
        ConfigurationSection spellParameters = this.spellTemplate.getSpellParameters();
        if (spellParameters != null) {
            Set parameterKeys = spellParameters.getKeys(false);
            for (String parameterKey : parameterKeys) {
                if (spellParameters.isConfigurationSection(parameterKey) || spellParameters.isList(parameterKey)) continue;
                String heroesKey = this.magicToHeroes(parameterKey);
                Object value = spellParameters.get(parameterKey);
                node.set(heroesKey, value);
                this.parameters.set(heroesKey, value);
            }
        }
        node.set("icon-url", (Object)this.spellTemplate.getIconURL());
        MaterialAndData icon = this.spellTemplate.getIcon();
        if (icon != null && icon.getMaterial() != Material.AIR) {
            node.set("icon", (Object)icon.getKey());
        }
        if ((disabledIcon = this.spellTemplate.getDisabledIcon()) != null && disabledIcon.getMaterial() != Material.AIR) {
            node.set("icon-disabled", (Object)disabledIcon.getKey());
        }
        node.set("icon-url", (Object)this.spellTemplate.getIconURL());
        node.set("icon-disabled-url", (Object)this.spellTemplate.getDisabledIconURL());
        node.set("cooldown", (Object)this.spellTemplate.getCooldown());
        node.set("name", (Object)this.spellTemplate.getName());
        Collection<CastingCost> costs = this.spellTemplate.getCosts();
        if (costs != null) {
            for (CastingCost cost : costs) {
                if (cost.getMana() <= 0) continue;
                node.set(SkillSetting.MANA.node(), (Object)cost.getMana());
            }
        }
        if ((upgrade = this.controller.getSpellTemplate((upgradeKey = new SpellKey(this.spellTemplate.getSpellKey().getBaseKey(), 2)).getKey())) != null) {
            int maxUpgrade = 2;
            while (upgrade != null) {
                upgradeKey = new SpellKey(this.spellTemplate.getSpellKey().getBaseKey(), maxUpgrade + 1);
                upgrade = this.controller.getSpellTemplate(upgradeKey.getKey());
                if (upgrade == null) continue;
                ++maxUpgrade;
            }
            node.set("tier", (Object)1);
            node.set("tier-max", (Object)maxUpgrade);
        }
        return node;
    }

    private String magicToHeroes(String key) {
        if (key.equals("range")) {
            return SkillSetting.MAX_DISTANCE.node();
        }
        return key.replace('_', '-');
    }

    private String heroesToMagic(String key) {
        if (key.equals(SkillSetting.MAX_DISTANCE.node())) {
            return "range";
        }
        return key.replace('-', '_');
    }

    public SpellTemplate getSpellTemplate() {
        return this.spellTemplate;
    }

    public String getDescription(Hero hero) {
        return this.getDescription();
    }
}

