/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.heroes;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.heroes.HeroesManager;
import com.elmakers.mine.bukkit.heroes.HeroesSpellSkill;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.CastingCost;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.PassiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class HeroesSkillSpell
extends BaseSpell {
    private String skillKey;
    private Skill skill;
    private HeroesManager heroes;
    private MagicController magic;
    private CastingCost manaCost;
    private boolean isCasting = false;

    @Override
    public boolean cast(@Nullable ConfigurationSection extraParameters, @Nullable Location defaultLocation) {
        boolean success = false;
        this.isCasting = true;
        try {
            success = super.cast(extraParameters, defaultLocation);
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Error using Heroes skill", ex);
        }
        this.isCasting = false;
        return success;
    }

    @Override
    public void loadTemplate(String key, ConfigurationSection template) {
        super.loadTemplate(key, template);
        this.skillKey = key.substring(7);
        this.showUndoable = false;
        this.manaCost = new CastingCost(this.controller, "mana", 1.0);
        if (!(this.controller instanceof MagicController)) {
            return;
        }
        this.magic = (MagicController)this.controller;
        this.heroes = this.magic.getHeroes();
        if (this.heroes == null) {
            return;
        }
        this.skill = this.heroes.getSkill(this.skillKey);
    }

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        CommandSender sender = this.mage.getCommandSender();
        this.controller.getPlugin().getServer().dispatchCommand(sender, "skill " + this.skillKey);
        return SpellResult.CAST;
    }

    @Override
    public void addLore(Messages messages, Mage mage, Wand wand, List<String> lore) {
        int mana;
        String cooldownDescription;
        int cooldown;
        String description;
        if (mage == null || !mage.isPlayer()) {
            return;
        }
        Hero hero = this.heroes.getHero(mage.getPlayer());
        if (hero == null) {
            return;
        }
        if (this.skill instanceof PassiveSkill) {
            lore.add(messages.get("skills.passive_description", "Passive"));
        }
        int level = SkillConfigManager.getUseSetting((Hero)hero, (Skill)this.skill, (SkillSetting)SkillSetting.LEVEL, (int)1, (boolean)true);
        String levelDescription = this.controller.getMessages().get("spell.level_description").replace("$level", Integer.toString(level));
        if (levelDescription != null && levelDescription.length() > 0) {
            lore.add(ChatColor.GOLD + levelDescription);
        }
        if ((description = this.getDescription()) == null || description.isEmpty()) {
            description = this.skill.getDescription(hero);
        }
        if (description != null && description.length() > 0) {
            CompatibilityLib.getInventoryUtils().wrapText(description, lore);
        }
        if ((cooldown = SkillConfigManager.getUseSetting((Hero)hero, (Skill)this.skill, (SkillSetting)SkillSetting.COOLDOWN, (int)0, (boolean)true)) > 0 && (cooldownDescription = this.getCooldownDescription(messages, cooldown, mage, wand)) != null && !cooldownDescription.isEmpty()) {
            lore.add(messages.get("cooldown.description").replace("$time", cooldownDescription));
        }
        if ((mana = SkillConfigManager.getUseSetting((Hero)hero, (Skill)this.skill, (SkillSetting)SkillSetting.MANA, (int)0, (boolean)true)) > 0) {
            String manaDescription = messages.get("currency.heroes_mana.amount").replace("$amount", Integer.toString(mana));
            lore.add(ChatColor.YELLOW + messages.get("wand.costs_description").replace("$description", manaDescription));
        }
    }

    @Override
    public long getRemainingCooldown() {
        if (this.isCasting || this.skill == null || this.mage == null) {
            return 0L;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return 0L;
        }
        Hero hero = this.heroes.getHero(this.mage.getPlayer());
        if (hero == null) {
            return 0L;
        }
        Long cooldown = hero.getCooldown(this.skillKey);
        if (cooldown == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        return Math.max(0L, cooldown - now);
    }

    @Override
    @Nullable
    public CastingCost getRequiredCost() {
        if (this.isCasting || this.skill == null || this.mage == null) {
            return null;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return null;
        }
        Hero hero = this.heroes.getHero(this.mage.getPlayer());
        if (hero == null) {
            return null;
        }
        int mana = SkillConfigManager.getUseSetting((Hero)hero, (Skill)this.skill, (SkillSetting)SkillSetting.MANA, (int)0, (boolean)true);
        if (mana == 0 || hero.getMana() > mana) {
            return null;
        }
        this.manaCost.setAmount(mana);
        return this.manaCost;
    }

    @Override
    public boolean canCast(Location location) {
        HeroesSpellSkill spellSkill;
        SpellTemplate template;
        MageSpell spell;
        if (!this.isCasting && this.mage != null && this.mage.isPlayer() && !this.heroes.canUseSkill(this.mage.getPlayer(), this.skillKey)) {
            return false;
        }
        if (this.skill instanceof HeroesSpellSkill && (spell = this.mage.getSpell((template = (spellSkill = (HeroesSpellSkill)this.skill).getSpellTemplate()).getKey())) != null) {
            return spell.canCast(location);
        }
        return super.canCast(location);
    }

    @Override
    public boolean hasCastPermission(CommandSender sender) {
        return true;
    }
}

