/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect.builtin;

import com.elmakers.mine.bukkit.effect.EffectRepeating;
import com.elmakers.mine.bukkit.slikey.effectlib.util.DynamicLocation;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EffectRing
extends EffectRepeating {
    protected int size = 8;
    protected float radius = 1.0f;
    private float useRadius;

    public EffectRing() {
    }

    public EffectRing(Plugin plugin) {
        super(plugin);
    }

    @Override
    public void load(Plugin plugin, ConfigurationSection configuration) {
        super.load(plugin, configuration);
        this.radius = (float)configuration.getDouble("radius", (double)this.radius);
        this.size = configuration.getInt("size", this.size);
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void run() {
        this.useRadius = this.radius == 0.0f ? (float)this.getRadius() : this.radius;
        super.run();
    }

    @Override
    public void iterate() {
        Location origin = this.getOrigin();
        if (origin == null) {
            return;
        }
        float currentRadius = this.scale(this.useRadius * this.useRadius);
        double startRadians = Math.random() * Math.PI * 2.0;
        for (int i = 0; i < this.size; ++i) {
            double radians = (double)i / (double)this.size * Math.PI * 2.0 + startRadians;
            Vector direction = new Vector(Math.cos(radians) * (double)currentRadius, 0.0, Math.sin(radians) * (double)currentRadius);
            Location source = origin;
            Location target = this.getTarget();
            if (this.playAtOrigin) {
                source = source.clone();
                source.add(direction);
            }
            if (target != null && this.playAtTarget) {
                target = target.clone();
                target.add(direction);
            }
            this.playEffect(new DynamicLocation(source, this.getOriginEntity()), new DynamicLocation(target, this.getTargetEntity()));
        }
    }
}

