/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect;

import com.elmakers.mine.bukkit.effect.EffectPlayer;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public abstract class EffectRepeating
extends EffectPlayer
implements Runnable {
    private static final Random random = new Random();
    protected int iterations = 4;
    protected int period = 1;
    protected double probability = 1.0;
    protected boolean reverse = false;
    protected Integer taskId;
    protected int iteration = 0;

    public EffectRepeating() {
    }

    public EffectRepeating(Plugin plugin) {
        super(plugin);
    }

    @Override
    public void load(Plugin plugin, ConfigurationSection configuration) {
        super.load(plugin, configuration);
        String durationString = configuration.getString("duration", "");
        this.period = configuration.contains("delay") ? configuration.getInt("delay") * 20 / 1000 : configuration.getInt("period", this.period);
        if (this.period < 1) {
            this.period = 1;
        }
        this.iterations = configuration.contains("duration") ? (durationString.equals("infinite") || durationString.equals("forever") || durationString.equals("infinity") ? Integer.MAX_VALUE : (int)Math.ceil(configuration.getDouble("duration") / (double)this.period / 50.0)) : configuration.getInt("iterations", this.iterations);
        this.probability = configuration.getDouble("probability", 1.0);
        this.reverse = configuration.getBoolean("reverse", this.reverse);
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public void play() {
        this.stop();
        this.iteration = 0;
        this.run();
    }

    @Override
    public void cancel() {
        this.stop();
        super.cancel();
    }

    public void stop() {
        this.iteration = this.iterations;
        if (this.taskId != null) {
            Bukkit.getScheduler().cancelTask(this.taskId.intValue());
            this.taskId = null;
        }
    }

    @Override
    public void run() {
        this.taskId = null;
        if (this.probability >= 1.0 || random.nextDouble() <= this.probability) {
            this.iterate();
        }
        if (++this.iteration < this.iterations) {
            this.schedule();
        }
    }

    protected void schedule() {
        if (this.plugin == null) {
            return;
        }
        this.taskId = Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, (Runnable)this, (long)this.period);
    }

    public float scale(float maxValue) {
        return (float)this.scale((double)maxValue);
    }

    public double scale(double maxValue) {
        int maxIteration = this.iterations - 1;
        if (maxIteration <= 0) {
            return maxValue;
        }
        double i = this.reverse ? (double)(maxIteration - this.iteration) : (double)this.iteration;
        return maxValue * (i / (double)maxIteration) * (i / (double)maxIteration);
    }

    public abstract void iterate();
}

