/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.crafting;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.crafting.MagicRecipe;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;

public class MagicShapelessRecipe
extends MagicRecipe {
    private String group;
    private ShapelessRecipe recipe;

    protected MagicShapelessRecipe(String key, MagicController controller) {
        super(key, controller);
    }

    @Override
    public ItemStack load(ConfigurationSection configuration) {
        ItemStack item = super.load(configuration);
        if (item == null) {
            return null;
        }
        this.group = configuration.getString("group", "");
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        List<String> ingredientKeys = ConfigurationUtils.getStringList(configuration, "ingredients");
        for (String ingredientKey : ingredientKeys) {
            ItemData ingredientItem = this.controller.getOrCreateItem(ingredientKey);
            if (ingredientItem == null) {
                this.controller.getLogger().warning("Could not create " + this.getType() + " recipe ingredient: " + ingredientKey);
                return null;
            }
            ingredients.add(ingredientItem.getItemStack());
        }
        this.recipe = CompatibilityLib.getCompatibilityUtils().createShapelessRecipe(this.key, item, ingredients, this.ignoreDamage);
        if (this.recipe != null && this.group != null && !this.group.isEmpty()) {
            CompatibilityLib.getCompatibilityUtils().setRecipeGroup((Recipe)this.recipe, this.group);
        }
        return item;
    }

    @Override
    public Recipe getRecipe() {
        return this.recipe;
    }

    @Override
    protected String getType() {
        return "shapeless";
    }
}

