/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.configuration;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.VariableScope;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.configuration.MageParameters;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;

public class SpellParameters
extends MageParameters {
    @Nullable
    private ConfigurationSection castVariables;
    @Nonnull
    private ConfigurationSection spellVariables;
    @Nullable
    private ConfigurationSection mageVariables;
    @Nonnull
    private final Set<String> allParameters = new HashSet<String>();
    @Nonnull
    private final MageSpell spell;
    @Nullable
    private CastContext context;

    public SpellParameters(@Nonnull MageSpell spell, @Nullable ConfigurationSection mageVariables, @Nullable ConfigurationSection variables) {
        super(spell.getMage(), "Spell: " + spell.getKey());
        this.spell = spell;
        this.spellVariables = spell.getVariables();
        this.mageVariables = mageVariables;
        Set<String> superParameters = super.getParameters();
        if (superParameters != null) {
            this.allParameters.addAll(superParameters);
        }
        this.castVariables = variables;
    }

    public SpellParameters(@Nonnull MageSpell spell, @Nullable ConfigurationSection variables) {
        this(spell, spell.getMage() != null ? spell.getMage().getVariables() : null, variables);
    }

    public SpellParameters(@Nonnull MageSpell spell, @Nonnull CastContext context) {
        this(spell, context.getVariables());
        this.context = context;
    }

    public SpellParameters(@Nonnull MageSpell spell, @Nonnull CastContext context, ConfigurationSection config) {
        this(spell, context);
        this.wrap(config);
    }

    public SpellParameters(SpellParameters copy) {
        super(copy);
        this.spell = copy.spell;
        this.castVariables = copy.castVariables;
        this.spellVariables = copy.spellVariables;
        this.mageVariables = copy.mageVariables;
        this.allParameters.addAll(copy.allParameters);
        this.context = copy.context;
    }

    @Override
    public double getParameter(String parameter) {
        ConfigurationSection spellParameters;
        Double value;
        if (this.castVariables != null && this.castVariables.contains(parameter)) {
            return this.castVariables.getDouble(parameter);
        }
        if (this.spellVariables.contains(parameter)) {
            return this.spellVariables.getDouble(parameter);
        }
        if (this.mageVariables != null && this.mageVariables.contains(parameter)) {
            return this.mageVariables.getDouble(parameter);
        }
        Double d = value = this.context != null ? this.context.getAttribute(parameter) : this.spell.getAttribute(parameter);
        if (value == null && (spellParameters = this.spell.getWorkingParameters()) != null && spellParameters.contains(parameter)) {
            return spellParameters.getDouble(parameter);
        }
        return value == null || Double.isNaN(value) || Double.isInfinite(value) ? 0.0 : value;
    }

    @Override
    public Set<String> getParameters() {
        ConfigurationSection spellParameters;
        if (this.castVariables != null) {
            this.allParameters.addAll(this.castVariables.getKeys(false));
        }
        this.allParameters.addAll(this.spellVariables.getKeys(false));
        if (this.mageVariables != null) {
            this.allParameters.addAll(this.mageVariables.getKeys(false));
        }
        if ((spellParameters = this.spell.getWorkingParameters()) != null) {
            this.allParameters.addAll(spellParameters.getKeys(false));
        }
        return this.allParameters;
    }

    public void setMageVariables(@Nonnull ConfigurationSection variables) {
        this.mageVariables = (ConfigurationSection)Preconditions.checkNotNull((Object)variables, (Object)"variables");
    }

    public void setSpellVariables(@Nonnull ConfigurationSection variables) {
        this.spellVariables = (ConfigurationSection)Preconditions.checkNotNull((Object)variables, (Object)"variables");
    }

    @Nullable
    public ConfigurationSection getVariables(VariableScope scope) {
        switch (scope) {
            case CAST: {
                return this.castVariables;
            }
            case SPELL: {
                return this.spellVariables;
            }
            case MAGE: {
                return this.mageVariables;
            }
        }
        return null;
    }

    public void setContext(CastContext context) {
        this.context = context;
    }

    @Nullable
    public CastContext getContext() {
        return this.context;
    }
}

