/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.citizens;

import com.elmakers.mine.bukkit.citizens.CitizensTrait;
import com.elmakers.mine.bukkit.utility.TextUtils;
import java.util.logging.Level;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.util.DataKey;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class CommandCitizensTrait
extends CitizensTrait {
    private String command;
    private boolean console = true;
    private boolean op = false;

    public CommandCitizensTrait() {
        super("command");
    }

    @Override
    public void load(DataKey data) {
        super.load(data);
        this.command = data.getString("command", null);
        this.console = data.getBoolean("console", true);
        this.op = data.getBoolean("op", false);
    }

    @Override
    public void save(DataKey data) {
        super.save(data);
        data.setString("command", this.command);
        data.setBoolean("console", this.console);
        data.setBoolean("op", this.op);
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isConsole() {
        return this.console;
    }

    public boolean isOP() {
        return this.op;
    }

    @Override
    public boolean perform(NPCRightClickEvent event) {
        String[] commands;
        if (this.command == null || this.command.isEmpty()) {
            return false;
        }
        Player sender = event.getClicker();
        Player player = event.getClicker();
        boolean result = true;
        boolean isOp = sender.isOp();
        if (this.op && !isOp) {
            sender.setOp(true);
        }
        Location location = player.getLocation();
        ConsoleCommandSender executor = this.console ? Bukkit.getConsoleSender() : player;
        for (String command : commands = StringUtils.split((String)this.command, (String)";")) {
            try {
                String converted = TextUtils.parameterize(command, location, player);
                this.api.getPlugin().getServer().dispatchCommand((CommandSender)executor, converted);
            }
            catch (Exception ex) {
                result = false;
                this.api.getLogger().log(Level.WARNING, "Error running command: " + command, ex);
            }
        }
        if (this.op && !isOp) {
            sender.setOp(false);
        }
        return result;
    }

    @Override
    public void describe(CommandSender sender) {
        super.describe(sender);
        String commandDescription = this.command == null ? ChatColor.RED + "(None)" : ChatColor.LIGHT_PURPLE + this.command;
        sender.sendMessage(ChatColor.DARK_PURPLE + "Command: " + commandDescription);
        String consoleDescription = this.console ? ChatColor.GRAY + "Console" : ChatColor.LIGHT_PURPLE + "Player";
        sender.sendMessage(ChatColor.DARK_PURPLE + "Executor: " + consoleDescription);
        String opDescription = this.console ? ChatColor.RED + "YES" : ChatColor.GRAY + "NO";
        sender.sendMessage(ChatColor.DARK_PURPLE + "Op Player: " + opDescription);
    }

    @Override
    public void configure(CommandSender sender, String key, String value) {
        if (key == null) {
            return;
        }
        if (key.equalsIgnoreCase("command")) {
            this.command = value;
            if (value == null) {
                sender.sendMessage(ChatColor.RED + "Cleared command");
            } else {
                sender.sendMessage(ChatColor.DARK_PURPLE + "Set command to: " + ChatColor.LIGHT_PURPLE + this.command);
            }
        } else if (key.equalsIgnoreCase("op")) {
            if (value == null || !value.equalsIgnoreCase("true")) {
                sender.sendMessage(ChatColor.DARK_PURPLE + "Player commands run normally");
                this.op = false;
            } else {
                this.op = true;
                sender.sendMessage(ChatColor.DARK_PURPLE + "Player commands run as OP");
            }
        } else if (key.equalsIgnoreCase("console")) {
            if (value == null || !value.equalsIgnoreCase("true")) {
                sender.sendMessage(ChatColor.DARK_PURPLE + "Set executor to player");
                this.console = false;
            } else {
                this.console = true;
                sender.sendMessage(ChatColor.DARK_PURPLE + "Set executor to console");
            }
        } else if ((value == null || value.isEmpty()) && !baseParameters.contains(key)) {
            this.command = key;
            sender.sendMessage(ChatColor.DARK_PURPLE + "Set spell to: " + ChatColor.LIGHT_PURPLE + this.command);
        } else {
            super.configure(sender, key, value);
        }
    }
}

