/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.citizens;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.citizens.CitizensTrait;
import com.elmakers.mine.bukkit.citizens.CommandCitizensTrait;
import com.elmakers.mine.bukkit.citizens.MagicCitizensTrait;
import com.elmakers.mine.bukkit.integration.NPCSupplier;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.npc.MagicNPC;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitInfo;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.trait.text.Text;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CitizensController
implements NPCSupplier {
    private Citizens citizensPlugin;
    private static Field textTraitText;
    private boolean hasTextTraitField;

    public CitizensController(Plugin plugin, MageController controller, boolean enableTraits) {
        this.citizensPlugin = (Citizens)plugin;
        if (enableTraits) {
            controller.getLogger().info("Citizens found, enabling magic and command traits");
            CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(MagicCitizensTrait.class).withName("magic"));
            CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(CommandCitizensTrait.class).withName("command"));
        } else {
            controller.getLogger().info("Citizens traits disabled.");
        }
    }

    public Citizens getCitizensPlugin() {
        return this.citizensPlugin;
    }

    @Nullable
    private NPC getNPC(Entity entity) {
        if (entity == null) {
            return null;
        }
        return CitizensAPI.getNPCRegistry().getNPC(entity);
    }

    @Override
    public boolean isNPC(Entity entity) {
        return this.getNPC(entity) != null;
    }

    @Override
    public boolean isStaticNPC(Entity entity) {
        NPC npc = this.getNPC(entity);
        if (npc == null) {
            return false;
        }
        return (Boolean)npc.data().get("protected", (Object)true);
    }

    public Collection<MagicNPC> importAll(MagicController controller, Mage creator) {
        int imported = 0;
        ArrayList<MagicNPC> npcs = new ArrayList<MagicNPC>();
        HashSet<Integer> alreadyImported = new HashSet<Integer>();
        for (com.elmakers.mine.bukkit.api.npc.MagicNPC npc : controller.getNPCs()) {
            Integer importedId = npc.getImportedId();
            if (importedId == null) continue;
            alreadyImported.add(importedId);
        }
        for (com.elmakers.mine.bukkit.api.npc.MagicNPC npc : this.citizensPlugin.getNPCRegistry()) {
            String name;
            Location location;
            if (alreadyImported.contains(npc.getId())) continue;
            Entity entity = npc.getEntity();
            if (entity == null) {
                try {
                    npc.spawn(npc.getStoredLocation());
                }
                catch (Exception ex) {
                    creator.sendMessage(ChatColor.RED + "An error occurred spawning NPC " + npc.getName() + ", please check logs");
                    ex.printStackTrace();
                }
                entity = npc.getEntity();
            }
            if ((location = npc.getStoredLocation()) == null || location.getWorld() == null) {
                Location location2 = location = entity == null ? null : entity.getLocation();
                if (location == null || location.getWorld() == null) {
                    creator.sendMessage(ChatColor.RED + "NPC " + npc.getName() + " is missing location and entity, skipping");
                    continue;
                }
                creator.sendMessage(ChatColor.YELLOW + "NPC " + npc.getName() + " is missing stored location, using entity location instead");
            }
            if ((name = npc.getName()) == null || name.isEmpty()) {
                creator.sendMessage(ChatColor.YELLOW + "NPC " + npc.getName() + " is missing a name, setting to 'NPC'");
                name = "NPC";
            }
            MagicNPC magicNPC = new MagicNPC(controller, creator, location, name);
            controller.registerNPC(magicNPC);
            ConfigurationSection parameters = magicNPC.getParameters();
            String entityType = "villager";
            if (entity == null) {
                creator.sendMessage(ChatColor.YELLOW + "NPC " + npc.getName() + " is missing entity, defaulting to villager");
            } else {
                entityType = entity.getType().name();
                if (entity instanceof Player) {
                    entityType = "villager";
                    ConfigurationSection disguise = ConfigurationUtils.newConfigurationSection();
                    disguise.set("type", (Object)"player");
                    disguise.set("skin", (Object)npc.getName());
                    parameters.set("disguise", (Object)disguise);
                } else if (entity instanceof Villager) {
                    Villager villager = (Villager)entity;
                    parameters.set("villager_profession", (Object)villager.getProfession().name().toLowerCase());
                }
            }
            for (Trait trait : npc.getTraits()) {
                String mobKey;
                if (trait instanceof Equipment) {
                    Equipment equipment = (Equipment)trait;
                    Map items = equipment.getEquipmentBySlot();
                    for (Equipment.EquipmentSlot slot : Equipment.EquipmentSlot.values()) {
                        ItemStack item = (ItemStack)items.get(slot);
                        if (CompatibilityLib.getItemUtils().isEmpty(item)) continue;
                        String key = null;
                        switch (slot) {
                            case HAND: {
                                key = "item";
                                break;
                            }
                            case BOOTS: {
                                key = "boots";
                                break;
                            }
                            case LEGGINGS: {
                                key = "leggings";
                                break;
                            }
                            case HELMET: {
                                key = "helmet";
                                break;
                            }
                            case CHESTPLATE: {
                                key = "chestplate";
                                break;
                            }
                            default: {
                                creator.sendMessage(ChatColor.YELLOW + "NPC " + npc.getName() + " has unhandled equipment slot " + slot);
                            }
                        }
                        if (key == null) continue;
                        parameters.set(key, (Object)controller.getItemKey(item));
                    }
                    continue;
                }
                if (trait instanceof Text) {
                    Text text = (Text)trait;
                    if (!this.hasTextTraitField) {
                        this.hasTextTraitField = true;
                        try {
                            textTraitText = Text.class.getDeclaredField("text");
                            textTraitText.setAccessible(true);
                        }
                        catch (NoSuchFieldException e) {
                            creator.sendMessage(ChatColor.YELLOW + "Error reading Text trait for NPC " + npc.getName() + ", dialog will not be imported");
                        }
                    }
                    if (textTraitText == null) continue;
                    try {
                        Collection lines = (Collection)textTraitText.get(text);
                        if (lines == null || lines.isEmpty()) continue;
                        parameters.set("dialog", (Object)lines);
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                        creator.sendMessage(ChatColor.YELLOW + "Error reading Text trait for NPC " + npc.getName() + ", dialog will not be imported");
                    }
                    continue;
                }
                if (!(trait instanceof CitizensTrait)) continue;
                CitizensTrait base = (CitizensTrait)trait;
                if (base.isInvisible()) {
                    ArrayList<ConfigurationSection> potionEffects = new ArrayList<ConfigurationSection>();
                    ConfigurationSection invisibility = ConfigurationUtils.newConfigurationSection();
                    invisibility.set("type", (Object)"invisibility");
                    invisibility.set("duration", (Object)"forever");
                    potionEffects.add(invisibility);
                    parameters.set("potion_effects", potionEffects);
                }
                ItemStack hat = base.getHat();
                if (!CompatibilityLib.getItemUtils().isEmpty(hat)) {
                    parameters.set("helmet", (Object)controller.getItemKey(hat));
                }
                if (base.getCost() > 0.0) {
                    ConfigurationSection costs = ConfigurationUtils.newConfigurationSection();
                    costs.set("currency", (Object)base.getCost());
                    parameters.set("costs", (Object)costs);
                }
                if ((mobKey = base.getMobKey()) != null && !mobKey.isEmpty()) {
                    entityType = mobKey;
                }
                parameters.set("interact_permission", (Object)base.getPermissionNode());
                if (trait instanceof CommandCitizensTrait) {
                    CommandCitizensTrait command = (CommandCitizensTrait)trait;
                    parameters.set("interact_commands", (Object)command.getCommand());
                    if (!command.isConsole()) {
                        if (command.isOP()) {
                            parameters.set("interact_command_source", (Object)"OPPED_PLAYER");
                        } else {
                            parameters.set("interact_command_source", (Object)"PLAYER");
                        }
                    }
                }
                if (!(trait instanceof MagicCitizensTrait)) continue;
                MagicCitizensTrait spell = (MagicCitizensTrait)trait;
                parameters.set("interact_spell", (Object)spell.getSpell());
                parameters.set("interact_spell_parameters", (Object)spell.getSpellParameters());
                if (!spell.isCaster()) {
                    parameters.set("interact_spell_source", (Object)"PLAYER");
                }
                if (!spell.isTargetPlayer()) continue;
                parameters.set("interact_spell_target", (Object)"PLAYER");
            }
            magicNPC.setImportedId(npc.getId());
            magicNPC.setType(entityType);
            ++imported;
        }
        if (imported == 0) {
            creator.sendMessage(ChatColor.YELLOW + "No Citizens NPCs to import out of " + ChatColor.WHITE + npcs.size() + ChatColor.YELLOW + ", are they all imported already?");
        } else {
            creator.sendMessage(ChatColor.AQUA + "Imported " + ChatColor.DARK_AQUA + imported + ChatColor.AQUA + " Citizens NPCs");
        }
        return npcs;
    }
}

