/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.arena;

import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.arena.Arena;
import com.elmakers.mine.bukkit.arena.ArenaController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import java.lang.ref.WeakReference;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffect;

public class ArenaPlayer
implements Comparable<ArenaPlayer> {
    private WeakReference<Mage> mage;
    private final Arena arena;
    private final UUID uuid;
    private String name;
    private String displayName;
    private int wins;
    private int losses;
    private int quits;
    private int joins;
    private int draws;

    public ArenaPlayer(Arena arena, ConfigurationSection config) {
        this.mage = null;
        this.arena = arena;
        this.uuid = UUID.fromString(config.getString("uuid"));
        this.name = config.getString("name");
        this.displayName = config.getString("display_name");
        this.wins = config.getInt("wins");
        this.losses = config.getInt("losses");
        this.quits = config.getInt("quits");
        this.joins = config.getInt("joins");
        this.draws = config.getInt("draws");
    }

    public ArenaPlayer(Arena arena, Player player) {
        this.uuid = player.getUniqueId();
        this.arena = arena;
        this.update(player);
    }

    public ArenaPlayer(Arena arena, UUID uuid) {
        this.uuid = uuid;
        this.arena = arena;
    }

    public void update(Player player) {
        if (player == null) {
            return;
        }
        ArenaController controller = this.arena.getController();
        this.name = player.getName();
        this.mage = new WeakReference<Mage>(controller.getMagic().getMage(player));
        this.displayName = player.getDisplayName();
        this.wins = this.get("won", this.wins);
        this.losses = this.get("lost", this.losses);
        this.quits = this.get("quit", this.quits);
        this.joins = this.get("joined", this.joins);
        this.draws = this.get("draw", this.draws);
    }

    public void save(ConfigurationSection config) {
        config.set("uuid", (Object)this.uuid.toString());
        config.set("name", (Object)this.name);
        config.set("display_name", (Object)this.displayName);
        config.set("wins", (Object)this.wins);
        config.set("losses", (Object)this.losses);
        config.set("quits", (Object)this.quits);
        config.set("joins", (Object)this.joins);
        config.set("draws", (Object)this.draws);
    }

    public boolean isValid() {
        Mage mage = this.getMage();
        return mage == null ? false : mage.isValid();
    }

    public boolean isDead() {
        Mage mage = this.getMage();
        return mage == null ? false : mage.isDead();
    }

    public Player getPlayer() {
        Mage mage = this.getMage();
        return mage == null ? null : mage.getPlayer();
    }

    public String getDisplayName() {
        String display = this.displayName;
        Mage mage = this.getMage();
        if (this.displayName == null && mage != null) {
            display = this.displayName = mage.getDisplayName();
        }
        return display;
    }

    public String getNameAndPath() {
        String display = this.getDisplayName();
        ProgressionPath path = this.getPath();
        if (path != null) {
            display = display + " " + ChatColor.GRAY + "(" + ChatColor.GOLD + path.getName() + ChatColor.GRAY + ")";
        }
        return display;
    }

    public void won() {
        Player player;
        Mage mage = this.getMage();
        Player player2 = player = mage == null ? null : mage.getPlayer();
        if (player != null) {
            int money;
            int sp;
            int xp = this.arena.getWinXP();
            if (xp > 0) {
                mage.sendMessage(ChatColor.AQUA + "You have been awarded " + ChatColor.DARK_AQUA + Integer.toString(xp) + ChatColor.AQUA + " experience!");
                mage.giveExperience(xp);
            }
            if ((sp = this.arena.getWinSP()) > 0) {
                mage.sendMessage(ChatColor.AQUA + "You have been awarded " + ChatColor.DARK_AQUA + Integer.toString(sp) + ChatColor.AQUA + " spell points!");
                mage.addSkillPoints(sp);
            }
            if ((money = this.arena.getWinMoney()) > 0) {
                mage.sendMessage(ChatColor.AQUA + "You have been awarded $" + ChatColor.DARK_AQUA + Integer.toString(money) + ChatColor.AQUA + "!");
                mage.addVaultCurrency(money);
            }
            this.wins = this.increment("won", this.wins);
        }
    }

    public void lost() {
        Player player;
        Mage mage = this.getMage();
        Player player2 = player = mage == null ? null : mage.getPlayer();
        if (player != null) {
            int money;
            int sp;
            int xp = this.arena.getLoseXP();
            if (xp > 0) {
                mage.sendMessage(ChatColor.AQUA + "You have been awarded " + ChatColor.DARK_AQUA + Integer.toString(xp) + ChatColor.AQUA + " experience!");
                mage.giveExperience(xp);
            }
            if ((sp = this.arena.getLoseSP()) > 0) {
                mage.sendMessage(ChatColor.AQUA + "You have been awarded " + ChatColor.DARK_AQUA + Integer.toString(sp) + ChatColor.AQUA + " spell points!");
                mage.addSkillPoints(sp);
            }
            if ((money = this.arena.getLoseMoney()) > 0) {
                mage.sendMessage(ChatColor.AQUA + "You have been awarded $" + ChatColor.DARK_AQUA + Integer.toString(money) + ChatColor.AQUA + "!");
                mage.addVaultCurrency(money);
            }
            this.losses = this.increment("lost", this.losses);
        }
    }

    public void quit() {
        this.quits = this.increment("quit", this.quits);
    }

    public void joined() {
        this.joins = this.increment("joined", this.joins);
    }

    public void draw() {
        Player player;
        this.teleport(this.arena.getLoseLocation());
        Mage mage = this.getMage();
        Player player2 = player = mage == null ? null : mage.getPlayer();
        if (player != null) {
            int money;
            int sp;
            int xp = this.arena.getDrawXP();
            if (xp > 0) {
                mage.sendMessage(ChatColor.AQUA + "You have been awarded " + ChatColor.DARK_AQUA + Integer.toString(xp) + ChatColor.AQUA + " experience!");
                mage.giveExperience(xp);
            }
            if ((sp = this.arena.getDrawSP()) > 0) {
                mage.sendMessage(ChatColor.AQUA + "You have been awarded " + ChatColor.DARK_AQUA + Integer.toString(sp) + ChatColor.AQUA + " spell points!");
                mage.addSkillPoints(sp);
            }
            if ((money = this.arena.getDrawMoney()) > 0) {
                mage.sendMessage(ChatColor.AQUA + "You have been awarded $" + ChatColor.DARK_AQUA + Integer.toString(money) + ChatColor.AQUA + "!");
                mage.addVaultCurrency(money);
            }
            this.draws = this.increment("draw", this.draws);
        }
    }

    public int getWins() {
        return this.wins;
    }

    public int getLosses() {
        return this.losses;
    }

    public int getQuits() {
        return this.quits;
    }

    public int getJoins() {
        return this.joins;
    }

    public int getDraws() {
        return this.draws;
    }

    public int getValidMatches() {
        return this.wins + this.losses;
    }

    public Arena getArena() {
        return this.arena;
    }

    protected int increment(String statName, int defaultValue) {
        Mage mage = this.getMage();
        if (mage == null) {
            return defaultValue;
        }
        String arenaKey = "arena." + this.arena.getKey() + "." + statName;
        ConfigurationSection data = mage.getData();
        int currentValue = data.getInt(arenaKey, 0);
        int newValue = currentValue + 1;
        data.set(arenaKey, (Object)newValue);
        return newValue;
    }

    protected int get(String statName, int defaultValue) {
        Mage mage = this.getMage();
        if (mage == null) {
            return defaultValue;
        }
        String arenaKey = "arena." + this.arena.getKey() + "." + statName;
        ConfigurationSection data = mage.getData();
        return data.getInt(arenaKey, 0);
    }

    public float getWinRatio() {
        if (this.losses == 0 && this.wins == 0) {
            return 0.0f;
        }
        return (float)this.wins / (float)(this.losses + this.wins);
    }

    public double getWinConfidence() {
        int nGames = this.wins + this.losses;
        if (nGames <= 0) {
            return 0.0;
        }
        double z = 1.96;
        double winRate = (double)this.wins / (double)nGames;
        double b = (winRate * (1.0 - winRate) + z * z / (double)(4 * nGames)) / (double)nGames;
        double a = winRate + z * z / (double)(2 * nGames) - z * Math.sqrt(b);
        return a / (1.0 + z * z / (double)nGames);
    }

    @Override
    public int compareTo(ArenaPlayer other) {
        return this.uuid.compareTo(other.getUUID());
    }

    public boolean equals(Object other) {
        if (other instanceof Player) {
            return this.equals((Player)other);
        }
        if (other instanceof UUID) {
            return this.equals((UUID)other);
        }
        if (!(other instanceof ArenaPlayer)) {
            return false;
        }
        return this.uuid.equals(((ArenaPlayer)other).uuid);
    }

    public boolean equals(Player player) {
        return player != null && player.getUniqueId().equals(this.uuid);
    }

    public boolean equals(UUID id) {
        return id != null && id.equals(this.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public void teleport(Location location) {
        Player player = this.getPlayer();
        if (player != null && location != null) {
            if (player.isDead()) {
                player.setMetadata("respawnLocation", (MetadataValue)new FixedMetadataValue(this.arena.getController().getPlugin(), (Object)location));
            } else {
                player.setMetadata("allow_teleport", (MetadataValue)new FixedMetadataValue(this.arena.getController().getPlugin(), (Object)true));
                player.teleport(location);
            }
        }
    }

    public void sendMessage(String message) {
        Mage mage = this.getMage();
        if (mage != null && !message.isEmpty()) {
            mage.sendMessage(message);
        }
    }

    public double getHealth() {
        Player player = this.getPlayer();
        return player == null ? 0.0 : player.getHealth();
    }

    public void heal() {
        Player player;
        Mage mage = this.getMage();
        Player player2 = player = mage == null ? null : mage.getPlayer();
        if (player != null && !player.isDead()) {
            double maxHealth = CompatibilityLib.getCompatibilityUtils().getMaxHealth((Damageable)player);
            player.setHealth(maxHealth);
            player.setFoodLevel(20);
            player.setSaturation(20.0f);
            player.setExhaustion(0.0f);
            player.setFireTicks(0);
            for (PotionEffect pt : player.getActivePotionEffects()) {
                if (pt.getDuration() >= 0x1FFFFFFF) continue;
                player.removePotionEffect(pt.getType());
            }
            mage.deactivateAllSpells(true, true);
        }
    }

    public void reset() {
        this.wins = 0;
        this.losses = 0;
        this.quits = 0;
        this.joins = 0;
        this.draws = 0;
        Mage mage = this.getMage();
        if (mage != null) {
            String arenaKey = "arena." + this.arena.getKey();
            ConfigurationSection data = mage.getData();
            data.set(arenaKey, null);
        }
    }

    public Mage getMage() {
        return this.mage == null ? null : (Mage)this.mage.get();
    }

    public ProgressionPath getPath() {
        Mage mage = this.getMage();
        if (mage == null) {
            return null;
        }
        CasterProperties mageClass = mage.getActiveProperties();
        return mageClass.getPath();
    }

    public boolean isBattling() {
        return this.arena != null && this.arena.isBattling(this);
    }
}

