/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.api.data;

import com.elmakers.mine.bukkit.api.spell.SpellKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class SpellData {
    private SpellKey spellKey;
    private boolean isActive;
    private boolean isEnabled = true;
    private long lastCast;
    private long lastEarn;
    private long castCount;
    private long cooldownExpiration;
    private double charges;
    private ConfigurationSection variables;

    public SpellData(SpellKey spellKey) {
        this.spellKey = spellKey;
    }

    public SpellData(String spellKey) {
        this(new SpellKey(spellKey));
    }

    @Deprecated
    public void setExtraData(ConfigurationSection data) {
        this.setVariables(data);
    }

    @Deprecated
    public ConfigurationSection getExtraData() {
        return this.getVariables();
    }

    public void setVariables(ConfigurationSection data) {
        this.variables = data;
    }

    public ConfigurationSection getVariables() {
        if (this.variables == null) {
            this.variables = new MemoryConfiguration();
        }
        return this.variables;
    }

    public SpellKey getKey() {
        return this.spellKey;
    }

    public void setKey(String spellKey) {
        this.spellKey = new SpellKey(spellKey);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public long getLastCast() {
        return this.lastCast;
    }

    public void setLastCast(long lastCast) {
        this.lastCast = lastCast;
    }

    public boolean useCharge(double regenerationRate, double maxCharges) {
        if (maxCharges <= 0.0 || regenerationRate <= 0.0) {
            return true;
        }
        double newCharges = this.getCharges(regenerationRate, maxCharges);
        if (newCharges < 1.0) {
            return false;
        }
        this.charges = newCharges - 1.0;
        return true;
    }

    public long getTimeToRecharge(double regenerationRate, double maxCharges) {
        if (maxCharges <= 0.0 || regenerationRate <= 0.0) {
            return 0L;
        }
        double charges = this.getCharges(regenerationRate, maxCharges);
        if (charges >= 1.0) {
            return 0L;
        }
        return (long)(1000.0 * (1.0 - charges) / regenerationRate);
    }

    public double getCharges(double regenerationRate, double maxCharges) {
        return Math.min(this.charges + regenerationRate * (double)(System.currentTimeMillis() - this.lastCast) / 1000.0, maxCharges);
    }

    public double getCharges() {
        return this.charges;
    }

    public void setCharges(double charges) {
        this.charges = charges;
    }

    public long getCastCount() {
        return this.castCount;
    }

    public void setCastCount(long castCount) {
        this.castCount = castCount;
    }

    public void addCast() {
        ++this.castCount;
    }

    public long getCooldownExpiration() {
        return this.cooldownExpiration;
    }

    public void setCooldownExpiration(long cooldownExpiration) {
        this.cooldownExpiration = cooldownExpiration;
    }

    public long getLastEarn() {
        return this.lastEarn;
    }

    public void setLastEarn(long lastEarn) {
        this.lastEarn = lastEarn;
    }
}

