/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseProjectileAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.magic.MagicMetaKeys;
import com.elmakers.mine.bukkit.magic.SourceLocation;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ThrowItemAction
extends BaseProjectileAction {
    private double itemSpeedMin;
    private double itemSpeedMax;
    private int ageItems;
    private int pickupDelay;
    private boolean unbreakable;
    private SourceLocation sourceLocation;
    private ItemData item;
    private boolean throwWand;
    private boolean temporary;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        double itemSpeed = parameters.getDouble("speed", 1.0);
        this.itemSpeedMin = parameters.getDouble("speed_min", itemSpeed);
        this.itemSpeedMax = parameters.getDouble("speed_max", itemSpeed);
        this.ageItems = parameters.getInt("age_items", 5500);
        this.unbreakable = parameters.getBoolean("unbreakable", false);
        this.throwWand = parameters.getBoolean("throw_wand", false);
        this.temporary = parameters.getBoolean("temporary", true);
        this.pickupDelay = parameters.getInt("pickup_delay", 0);
        this.sourceLocation = new SourceLocation(parameters);
        String itemName = parameters.getString("item");
        if (itemName != null && !itemName.isEmpty()) {
            this.item = context.getController().getOrCreateItem(itemName);
        }
    }

    @Override
    public SpellResult start(CastContext context) {
        Location spawnLocation = this.sourceLocation.getLocation(context);
        if (spawnLocation == null) {
            return SpellResult.NO_TARGET;
        }
        ItemStack itemStack = null;
        if (this.throwWand) {
            Wand wand = context.getWand();
            if (wand == null) {
                return SpellResult.NO_TARGET;
            }
            wand.deactivate();
            itemStack = wand.getItem();
            if (CompatibilityLib.getItemUtils().isEmpty(itemStack)) {
                return SpellResult.FAIL;
            }
            int slotNumber = wand.getHeldSlot();
            Player player = context.getMage().getPlayer();
            if (player != null) {
                player.getInventory().setItem(slotNumber, new ItemStack(Material.AIR));
            }
        } else if (this.item != null) {
            itemStack = this.item.getItemStack(1);
        } else {
            MaterialBrush material = context.getBrush();
            if (material != null) {
                itemStack = CompatibilityLib.getDeprecatedUtils().createItemStack(material.getMaterial(), 1, material.getData());
            }
        }
        if (itemStack == null) {
            return SpellResult.NO_TARGET;
        }
        double itemSpeed = context.getRandom().nextDouble() * (this.itemSpeedMax - this.itemSpeedMin) + this.itemSpeedMin;
        Vector velocity = spawnLocation.getDirection().normalize().multiply(itemSpeed);
        if (this.unbreakable) {
            itemStack = CompatibilityLib.getItemUtils().makeReal(itemStack);
            CompatibilityLib.getItemUtils().makeUnbreakable(itemStack);
        }
        Item droppedItem = null;
        try {
            droppedItem = spawnLocation.getWorld().dropItem(spawnLocation, itemStack);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (droppedItem == null) {
            context.getMage().sendDebugMessage("Failed to spawn item of type " + itemStack.getType());
            return SpellResult.FAIL;
        }
        if (this.temporary) {
            CompatibilityLib.getEntityMetadataUtils().setBoolean((Entity)droppedItem, MagicMetaKeys.TEMPORARY, true);
            itemStack = droppedItem.getItemStack();
            if (itemStack != null) {
                String removedMessage = context.getMessage("removed");
                String name = context.getController().describeItem(itemStack);
                removedMessage = removedMessage.replace("$material", name);
                CompatibilityLib.getItemUtils().makeTemporary(itemStack, removedMessage);
                droppedItem.setItemStack(itemStack);
            }
        }
        if (this.ageItems > 0) {
            CompatibilityLib.getCompatibilityUtils().ageItem(droppedItem, this.ageItems);
        }
        if (this.pickupDelay > 0) {
            droppedItem.setPickupDelay(this.pickupDelay);
        }
        SafetyUtils.setVelocity((Entity)droppedItem, velocity);
        this.track(context, (Entity)droppedItem);
        return this.checkTracking(context);
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean usesBrush() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("speed");
        parameters.add("speed_min");
        parameters.add("speed_max");
        parameters.add("age_items");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("speed") || parameterKey.equals("age_items") || parameterKey.equals("speed_max") || parameterKey.equals("speed_min")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

