/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import java.lang.ref.WeakReference;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

public class TakeItemAction
extends BaseSpellAction {
    private String displayName;
    private MaterialAndData itemType;
    private boolean giveToCaster;
    private boolean fullStack;
    private boolean takeWand;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.takeWand = parameters.getBoolean("take_wand", false);
        this.displayName = parameters.getString("display_name", null);
        if (this.displayName != null) {
            this.displayName = CompatibilityLib.getCompatibilityUtils().translateColors(this.displayName);
        }
        this.giveToCaster = !this.takeWand;
        String itemKey = parameters.getString("item", "");
        if (!itemKey.isEmpty()) {
            this.giveToCaster = false;
            this.itemType = new MaterialAndData(itemKey);
        }
        this.giveToCaster = parameters.getBoolean("give_to_caster", this.giveToCaster);
        this.fullStack = parameters.getBoolean("full_stack", true);
    }

    private boolean checkItem(ItemStack item) {
        MaterialAndData check;
        ItemMeta meta;
        if (!(this.displayName == null || (meta = item.getItemMeta()) != null && meta.hasDisplayName() && meta.getDisplayName().equals(this.displayName))) {
            return false;
        }
        return this.itemType == null || this.itemType.equals(check = new MaterialAndData(item));
    }

    @Override
    public SpellResult perform(CastContext context) {
        Item itemEntity;
        ItemStack itemStack;
        Entity target = context.getTargetEntity();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        ItemStack item = null;
        if (this.takeWand) {
            com.elmakers.mine.bukkit.api.magic.Mage targetMage = context.getController().getMage(target);
            Wand wand = targetMage == context.getMage() ? context.getWand() : targetMage.getActiveWand();
            if (wand != null) {
                wand.deactivate();
                item = wand.getItem();
                if (wand.isInOffhand()) {
                    if (target instanceof Player) {
                        Player targetPlayer = (Player)target;
                        PlayerInventory playerInventory = targetPlayer.getInventory();
                        playerInventory.setItemInOffHand(null);
                    } else if (target instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)target;
                        EntityEquipment equipment = livingEntity.getEquipment();
                        if (equipment != null) {
                            equipment.setItemInOffHand(null);
                        }
                    } else {
                        item = null;
                    }
                } else if (target instanceof Player) {
                    Player targetPlayer = (Player)target;
                    PlayerInventory playerInventory = targetPlayer.getInventory();
                    playerInventory.setItemInMainHand(null);
                } else if (target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    EntityEquipment equipment = livingEntity.getEquipment();
                    if (equipment != null) {
                        equipment.setItemInMainHand(null);
                    }
                } else {
                    item = null;
                }
                targetMage.checkWand();
            }
        } else if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            PlayerInventory playerInventory = targetPlayer.getInventory();
            for (int slotNumber = 0; slotNumber < playerInventory.getSize(); ++slotNumber) {
                ItemStack inventoryItem = playerInventory.getItem(slotNumber);
                if (CompatibilityLib.getItemUtils().isEmpty(inventoryItem) || !this.checkItem(inventoryItem)) continue;
                if (this.fullStack || inventoryItem.getAmount() == 1) {
                    item = inventoryItem;
                    inventoryItem = null;
                } else {
                    item = CompatibilityLib.getItemUtils().getCopy(inventoryItem);
                    item.setAmount(1);
                    inventoryItem.setAmount(inventoryItem.getAmount() - 1);
                }
                TakeUndoAction undoAction = new TakeUndoAction(context.getController(), targetPlayer, item, slotNumber);
                context.registerForUndo(undoAction);
                playerInventory.setItem(slotNumber, inventoryItem);
                com.elmakers.mine.bukkit.api.magic.Mage mage = context.getController().getRegisteredMage((Entity)targetPlayer);
                if (mage != null && mage instanceof Mage) {
                    ((Mage)mage).armorUpdated();
                }
                break;
            }
        } else if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            EntityEquipment equipment = livingEntity.getEquipment();
            ItemStack equipmentItem = equipment.getItemInMainHand();
            if (equipment != null) {
                if (this.checkItem(equipmentItem)) {
                    context.registerModified((Entity)livingEntity);
                    equipment.setItemInMainHand(null);
                    item = equipmentItem;
                }
                equipmentItem = equipment.getItemInOffHand();
                if (item == null && this.checkItem(equipmentItem)) {
                    context.registerModified((Entity)livingEntity);
                    equipment.setItemInOffHand(null);
                    item = equipmentItem;
                }
                if (item == null) {
                    ItemStack[] armor = equipment.getArmorContents();
                    for (int i = 0; i < armor.length; ++i) {
                        if (!this.checkItem(armor[i])) continue;
                        context.registerModified((Entity)livingEntity);
                        item = armor[i];
                        armor[i] = null;
                        equipment.setArmorContents(armor);
                        break;
                    }
                }
            }
        } else if (target instanceof Item && this.checkItem(itemStack = (itemEntity = (Item)target).getItemStack())) {
            item = itemStack;
            context.registerModified((Entity)itemEntity);
            itemEntity.remove();
        }
        if (CompatibilityLib.getItemUtils().isEmpty(item)) {
            return SpellResult.NO_TARGET;
        }
        if (this.giveToCaster) {
            context.getMage().giveItem(item);
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }

    private static class TakeUndoAction
    implements Runnable {
        private final MageController controller;
        private final WeakReference<Player> player;
        private final Location location;
        private final int slotNumber;
        private ItemStack item;

        public TakeUndoAction(MageController controller, Player player, ItemStack item, int slotNumber) {
            this.controller = controller;
            this.player = new WeakReference<Player>(player);
            this.location = player.getLocation();
            this.slotNumber = slotNumber;
            this.item = item;
        }

        private void returnItem() {
            if (this.item == null) {
                return;
            }
            Player player = (Player)this.player.get();
            if (player == null || !player.isOnline()) {
                this.location.getWorld().dropItem(this.location, this.item);
                return;
            }
            PlayerInventory playerInventory = player.getInventory();
            ItemStack currentItem = playerInventory.getItem(this.slotNumber);
            if (CompatibilityLib.getItemUtils().isEmpty(currentItem)) {
                playerInventory.setItem(this.slotNumber, this.item);
            } else {
                this.controller.giveItemToPlayer(player, this.item);
            }
            this.item = null;
            com.elmakers.mine.bukkit.api.magic.Mage targetMage = this.controller.getRegisteredMage((Entity)player);
            if (targetMage != null && targetMage instanceof Mage) {
                ((Mage)targetMage).armorUpdated();
            }
        }

        @Override
        public void run() {
            this.returnItem();
        }
    }
}

