/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RemoveWandAction
extends BaseSpellAction {
    @Override
    public SpellResult perform(CastContext context) {
        Mage mage = context.getMage();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        Wand activeWand = mage.getActiveWand();
        Wand offhandWand = mage.getOffhandWand();
        ItemStack activeItem = null;
        boolean isOffhand = false;
        if (offhandWand == context.getWand()) {
            isOffhand = true;
            activeWand = offhandWand;
            activeItem = player.getInventory().getItemInOffHand();
        } else {
            if (activeWand != context.getWand()) {
                return SpellResult.NO_TARGET;
            }
            isOffhand = false;
            activeItem = player.getInventory().getItemInMainHand();
        }
        if (CompatibilityLib.getItemUtils().isEmpty(activeItem)) {
            return SpellResult.FAIL;
        }
        if (activeWand != null) {
            activeWand.deactivate();
        }
        if (isOffhand) {
            player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
        } else {
            player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
        }
        mage.checkWand();
        return SpellResult.CAST;
    }
}

