/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.effect.SoundEffect;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlaySoundAction
extends BaseSpellAction {
    private SoundEffect sound;
    private int radius;
    private boolean countAsCast;

    @Override
    public SpellResult perform(CastContext context) {
        if (this.sound == null) {
            return SpellResult.FAIL;
        }
        this.sound.setRange(this.radius);
        if (this.radius == 0) {
            Entity entity = context.getTargetEntity();
            if (entity == null || !(entity instanceof Player)) {
                return SpellResult.NO_TARGET;
            }
            this.sound.play(context.getPlugin(), context.getController().getLogger(), entity);
            return this.countAsCast ? SpellResult.CAST : SpellResult.NO_ACTION;
        }
        Location location = context.getTargetLocation();
        if (location == null) {
            location = context.getLocation();
        }
        if (location == null) {
            return SpellResult.NO_TARGET;
        }
        this.sound.play(context.getPlugin(), context.getLogger(), location);
        return this.countAsCast ? SpellResult.CAST : SpellResult.NO_ACTION;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.sound = new SoundEffect(parameters.getString("sound"));
        this.sound.setPitch((float)parameters.getDouble("pitch", (double)this.sound.getPitch()));
        this.sound.setPitch((float)parameters.getDouble("sound_pitch", (double)this.sound.getPitch()));
        this.sound.setVolume((float)parameters.getDouble("volume", (double)this.sound.getVolume()));
        this.sound.setVolume((float)parameters.getDouble("sound_volume", (double)this.sound.getVolume()));
        this.radius = parameters.getInt("radius", 32);
        this.countAsCast = parameters.getBoolean("effects_count_as_cast", false);
        this.countAsCast = parameters.getBoolean("sounds_count_as_cast", this.countAsCast);
    }
}

