/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.lang.ref.WeakReference;
import java.util.Collection;
import org.bukkit.GameMode;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ModifyGameModeAction
extends BaseSpellAction {
    private GameMode gameMode;
    private GameMode originalMode;
    private WeakReference<Player> targetPlayer;

    private void resetMode() {
        if (this.targetPlayer == null) {
            return;
        }
        Player player = (Player)this.targetPlayer.get();
        if (player == null) {
            return;
        }
        player.setGameMode(this.originalMode);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity entity = context.getTargetEntity();
        if (entity == null) {
            return SpellResult.NO_TARGET;
        }
        if (!(entity instanceof Player)) {
            return SpellResult.PLAYER_REQUIRED;
        }
        Player player = (Player)entity;
        this.originalMode = player.getGameMode();
        if (this.originalMode == this.gameMode) {
            return SpellResult.NO_TARGET;
        }
        player.setGameMode(this.gameMode);
        this.targetPlayer = new WeakReference<Player>(player);
        context.registerForUndo(new GameModeUndoAction());
        return SpellResult.CAST;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        String gameModeString = parameters.getString("game_mode");
        try {
            this.gameMode = GameMode.valueOf((String)gameModeString.toUpperCase());
        }
        catch (Exception ex) {
            context.getLogger().warning("Invalid game mode: " + gameModeString);
        }
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("game_mode");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("game_mode")) {
            for (GameMode mode : GameMode.values()) {
                examples.add(mode.name().toLowerCase());
            }
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    private class GameModeUndoAction
    implements Runnable {
        @Override
        public void run() {
            ModifyGameModeAction.this.resetMode();
        }
    }
}

