/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.ActionBarSender;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class MessageAction
extends BaseSpellAction {
    private String messageKey = null;
    private String message = "";
    private String subMessage = "";
    private String dialogFormatKey = "";
    private int fadeIn;
    private int stay;
    private int fadeOut;
    private boolean messageTarget = false;
    private MessageType messageType = MessageType.MAGE;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        String messageTypeString;
        super.prepare(context, parameters);
        this.messageKey = parameters.getString("message_key");
        this.message = this.messageKey != null ? context.getMessage(this.messageKey) : CompatibilityLib.getCompatibilityUtils().translateColors(parameters.getString("message", ""));
        String subMessageKey = parameters.getString("sub_message_key");
        this.subMessage = subMessageKey != null ? context.getMessage(subMessageKey) : CompatibilityLib.getCompatibilityUtils().translateColors(parameters.getString("sub_message", ""));
        this.fadeIn = parameters.getInt("fade_in", -1);
        this.stay = parameters.getInt("stay", -1);
        this.fadeOut = parameters.getInt("fade_out", -1);
        this.messageTarget = parameters.getBoolean("message_target", false);
        this.dialogFormatKey = parameters.getString("dialog_format", "");
        if (parameters.contains("equation")) {
            double value = parameters.getDouble("equation");
            this.message = this.message.replace("$equation", Double.toString(value)).replace("@equation", Integer.toString((int)value));
        }
        if ((messageTypeString = parameters.getString("message_type", null)) != null) {
            try {
                this.messageType = MessageType.valueOf(messageTypeString.toUpperCase());
            }
            catch (Exception ex) {
                context.getLogger().warning("Not a valid message_type: " + messageTypeString);
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.messageTarget) {
            Entity targetEntity = context.getTargetEntity();
            if (targetEntity == null || !(targetEntity instanceof Player)) {
                return SpellResult.NO_TARGET;
            }
            this.sendMessage(context, (CommandSender)targetEntity);
            return SpellResult.CAST;
        }
        Mage mage = context.getMage();
        CommandSender commandSender = mage.getCommandSender();
        if (commandSender == null) {
            return SpellResult.FAIL;
        }
        return this.sendMessage(context, commandSender);
    }

    private SpellResult sendMessage(CastContext context, CommandSender commandSender) {
        String message = this.message;
        if (this.messageKey == null) {
            message = context.getMessage(this.message, this.message);
        }
        message = context.parameterize(message);
        message = message.replace("$spell", context.getSpell().getName());
        if (!this.dialogFormatKey.isEmpty()) {
            String targetName = "Nobody";
            Entity targetEntity = context.getTargetEntity();
            if (targetEntity != null) {
                targetName = context.getController().getEntityDisplayName(targetEntity);
            }
            String template = context.getMessage(this.dialogFormatKey);
            message = template.replace("$line", message);
            message = message.replace("$speaker", context.getMage().getDisplayName()).replace("$target", targetName);
        }
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        switch (this.messageType) {
            case MAGE: {
                Mage mage = context.getController().getMage(commandSender);
                mage.sendMessage(message);
                break;
            }
            case CHAT: {
                commandSender.sendMessage(message);
                break;
            }
            case TITLE: {
                if (player == null) {
                    return SpellResult.PLAYER_REQUIRED;
                }
                String subMessage = context.parameterize(context.getMessage(this.subMessage, this.subMessage));
                CompatibilityLib.getCompatibilityUtils().sendTitle(player, message, subMessage, this.fadeIn, this.stay, this.fadeOut);
                break;
            }
            case ACTION_BAR: {
                if (player == null) {
                    return SpellResult.PLAYER_REQUIRED;
                }
                Mage targetMage = context.getController().getRegisteredMage((Entity)player);
                if (targetMage != null && targetMage instanceof ActionBarSender) {
                    ActionBarSender actionBarSender = (ActionBarSender)((Object)targetMage);
                    actionBarSender.sendToActionBar(message);
                    break;
                }
                if (CompatibilityLib.getCompatibilityUtils().sendActionBar(player, message)) break;
                player.sendMessage(message);
            }
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("message_key");
        parameters.add("message");
        parameters.add("equation");
        parameters.add("sub_message");
        parameters.add("sub_message_key");
        parameters.add("message_type");
        parameters.add("message_target");
        parameters.add("stay");
        parameters.add("fade_in");
        parameters.add("fade_out");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("message") || parameterKey.equals("sub_message")) {
            examples.add("You cast $spell on $target");
        } else if (parameterKey.equals("equation")) {
            examples.add("intelligence + strength / 20");
        } else if (parameterKey.equals("fade_in") || parameterKey.equals("fade_out") || parameterKey.equals("stay")) {
            examples.add("-1");
            examples.add("10");
            examples.add("20");
            examples.add("70");
        } else if (parameterKey.equals("message_type")) {
            for (MessageType messageType : MessageType.values()) {
                examples.add(messageType.name().toLowerCase());
            }
        } else if (parameterKey.equals("message_target")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    public static enum MessageType {
        MAGE,
        CHAT,
        TITLE,
        ACTION_BAR;

    }
}

