/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CheckAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class CheckModifiersAction
extends CheckAction {
    private Collection<String> required;
    private Collection<String> blocked;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.required = ConfigurationUtils.getStringList(parameters, "required");
        this.blocked = ConfigurationUtils.getStringList(parameters, "blocked");
    }

    @Override
    protected boolean isAllowed(CastContext context) {
        Entity targetEntity = context.getTargetEntity();
        Mage mage = context.getController().getRegisteredMage(targetEntity);
        if (this.blocked != null && mage != null) {
            for (String check : this.blocked) {
                if (!mage.hasModifier(check)) continue;
                return false;
            }
        }
        if (this.required != null) {
            if (mage == null) {
                return false;
            }
            for (String check : this.required) {
                if (!mage.hasModifier(check)) continue;
                return true;
            }
        }
        return this.required == null || this.required.isEmpty();
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("required");
        parameters.add("blocked");
    }
}

