/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CheckAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import org.bukkit.configuration.ConfigurationSection;

public class CheckManaAction
extends CheckAction {
    private boolean requireNotFull = false;
    private boolean requireEmpty = false;
    private double requireAmount = 0.0;
    private double requirePercentage = 0.0;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.requirePercentage = parameters.getDouble("require_mana_percentage", 0.0);
        this.requireAmount = parameters.getDouble("require_mana", 0.0);
        this.requireNotFull = parameters.getBoolean("require_mana_not_full", false);
        this.requireEmpty = parameters.getBoolean("require_mana_empty", false);
    }

    @Override
    protected boolean isAllowed(CastContext context) {
        Mage mage = context.getMage();
        double currentMana = mage.getMana();
        if (this.requireAmount > 0.0 && currentMana < this.requireAmount) {
            return false;
        }
        if (this.requireEmpty && currentMana > 0.0) {
            return false;
        }
        int manaMax = mage.getEffectiveManaMax();
        if (this.requireNotFull && currentMana >= (double)manaMax) {
            return false;
        }
        return !(this.requirePercentage > 0.0) || manaMax <= 0 || !(currentMana / (double)manaMax < this.requirePercentage);
    }

    @Override
    public boolean requiresTarget() {
        return false;
    }
}

