/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class CancelAction
extends BaseSpellAction {
    private String undoListName;
    private Collection<String> spellKeys;
    private boolean force;
    private boolean current;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        String targetSpellKey;
        super.prepare(context, parameters);
        this.force = parameters.getBoolean("force", false);
        this.current = parameters.getBoolean("current", true);
        if (parameters.contains("spells")) {
            this.spellKeys = ConfigurationUtils.getStringList(parameters, "spells");
        } else if (parameters.contains("spell") && (targetSpellKey = parameters.getString("spell", null)) != null && !targetSpellKey.isEmpty()) {
            this.spellKeys = new ArrayList<String>();
            this.spellKeys.add(targetSpellKey);
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity targetEntity = context.getTargetEntity();
        MageController controller = context.getController();
        if (targetEntity == null || !controller.isMage(targetEntity)) {
            return SpellResult.NO_TARGET;
        }
        SpellResult result = SpellResult.NO_TARGET;
        Mage targetMage = controller.getMage(targetEntity);
        if (this.spellKeys == null) {
            Batch batch = targetMage.cancelPending(this.force);
            if (batch != null) {
                result = SpellResult.CAST;
                this.undoListName = batch.getName();
            }
        } else {
            for (String spellKey : this.spellKeys) {
                Batch batch = targetMage.cancelPending(spellKey, this.force, this.current);
                if (batch == null) continue;
                result = SpellResult.CAST;
                this.undoListName = batch.getName();
            }
        }
        return result;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }

    @Override
    public String transformMessage(String message) {
        return message.replace("$undo", this.undoListName == null ? "Unknown" : this.undoListName);
    }
}

