/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;

public abstract class CompoundLocationAction
extends CompoundAction {
    private List<Location> locations = new ArrayList<Location>();
    private int currentLocation = 0;
    protected int targetCount;

    public abstract void addLocations(CastContext var1, List<Location> var2);

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.targetCount = parameters.getInt("target_count", -1);
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.currentLocation = 0;
    }

    @Override
    public SpellResult start(CastContext context) {
        this.locations.clear();
        this.addLocations(context, this.locations);
        if (this.targetCount > 0) {
            final Location source = context.getTargetLocation();
            Collections.sort(this.locations, new Comparator<Location>(){

                @Override
                public int compare(Location o1, Location o2) {
                    double d1 = o1.distanceSquared(source);
                    double d2 = o2.distanceSquared(source);
                    return (int)(d1 - d2);
                }
            });
        }
        context.addWork(10 + this.locations.size());
        return SpellResult.NO_TARGET;
    }

    @Override
    public boolean next(CastContext context) {
        ++this.currentLocation;
        if (this.targetCount > 0 && this.currentLocation >= this.targetCount) {
            return false;
        }
        return this.currentLocation < this.locations.size();
    }

    @Override
    public SpellResult step(CastContext context) {
        if (this.currentLocation < this.locations.size()) {
            Location location = this.locations.get(this.currentLocation);
            this.actionContext.setTargetLocation(location);
            return this.startActions();
        }
        return SpellResult.NO_ACTION;
    }

    @Override
    @Nullable
    public Object clone() {
        CompoundLocationAction action = (CompoundLocationAction)super.clone();
        if (action != null) {
            action.locations = new ArrayList<Location>(this.locations);
        }
        return action;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("target_count");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("target_count")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

