/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.action.CastContext;
import com.elmakers.mine.bukkit.api.action.SpellAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public abstract class CompoundAction
extends BaseSpellAction {
    private boolean usesBrush = false;
    private boolean undoable = false;
    private boolean requiresBuildPermission = false;
    private boolean requiresBreakPermission = false;
    private boolean stopOnSuccess = false;
    private boolean initialized = false;
    private boolean started = false;
    protected boolean pauseOnNext = false;
    @Nullable
    protected ConfigurationSection actionConfiguration;
    @Nullable
    protected com.elmakers.mine.bukkit.api.action.CastContext actionContext;
    @Nullable
    private Object baseActions;
    protected Map<String, ActionHandler> handlers = new HashMap<String, ActionHandler>();
    protected Set<String> handlerKeys = new HashSet<String>();
    protected Set<ActionHandler> ran = null;
    @Nullable
    protected String currentHandler = null;
    protected State state = State.NOT_STARTED;

    public SpellResult step(com.elmakers.mine.bukkit.api.action.CastContext context) {
        return SpellResult.NO_ACTION;
    }

    public boolean next(com.elmakers.mine.bukkit.api.action.CastContext context) {
        return false;
    }

    protected SpellResult startActions() {
        return this.startActions("actions");
    }

    protected SpellResult startActions(String handlerKey) {
        Preconditions.checkState((this.actionContext != null ? 1 : 0) != 0);
        this.currentHandler = handlerKey;
        ActionHandler handler = this.handlers.get(this.currentHandler);
        if (handler != null) {
            handler.reset(this.actionContext);
            this.ran.add(handler);
        } else {
            this.currentHandler = null;
        }
        return SpellResult.NO_ACTION;
    }

    public boolean hasActions() {
        return this.hasActions("actions");
    }

    public boolean hasActions(String key) {
        ActionHandler handler = this.handlers.get(key);
        return handler != null && handler.size() > 0;
    }

    @Override
    public SpellResult perform(com.elmakers.mine.bukkit.api.action.CastContext context) {
        SpellResult result = SpellResult.NO_ACTION;
        while (!result.isStop()) {
            ActionHandler handler;
            context.addWork(1);
            if (this.state == State.NOT_STARTED) {
                if ((result = result.min(this.start(context))).isStop() || result.isFailure()) break;
                this.state = State.STARTED;
            }
            if (this.state == State.STARTED) {
                if ((result = result.min(this.step(context))).isStop()) break;
                this.state = State.STEPPING;
            }
            ActionHandler actionHandler = handler = this.currentHandler == null ? null : this.handlers.get(this.currentHandler);
            if (handler != null) {
                if ((result = result.min(handler.perform(this.actionContext))).isStop()) break;
                if (this.stopOnSuccess && result.isSuccess()) {
                    result = SpellResult.STOP;
                    break;
                }
            }
            if (!this.next(context)) break;
            result = result.min(this.step(context));
            if (!this.pauseOnNext && context.getWorkAllowed() > 0 || result.isStop()) continue;
            result = SpellResult.PENDING;
        }
        return result;
    }

    @Override
    public void finish(com.elmakers.mine.bukkit.api.action.CastContext context) {
        super.finish(context);
        for (ActionHandler handler : this.ran) {
            handler.finish(context);
        }
        this.ran.clear();
    }

    @Override
    public void reset(com.elmakers.mine.bukkit.api.action.CastContext context) {
        super.reset(context);
        if (context != null) {
            this.actionContext = new CastContext(context);
        }
        this.state = State.NOT_STARTED;
        this.currentHandler = null;
    }

    public SpellResult start(com.elmakers.mine.bukkit.api.action.CastContext context) {
        return SpellResult.NO_ACTION;
    }

    @Override
    public void start(com.elmakers.mine.bukkit.api.action.CastContext context, ConfigurationSection parameters) {
        super.start(context, parameters);
        this.ran = new HashSet<ActionHandler>();
        for (ActionHandler handler : this.handlers.values()) {
            handler.start(context, context.getWorkingParameters());
        }
        this.started = true;
    }

    @Override
    public void prepare(com.elmakers.mine.bukkit.api.action.CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.stopOnSuccess = parameters.getBoolean("stop_on_success", false);
        if (this.started) {
            for (ActionHandler handler : this.handlers.values()) {
                handler.prepare(context, context.getWorkingParameters());
            }
        }
    }

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.actionConfiguration = parameters;
        this.baseActions = parameters.get("actions");
        this.usesBrush = false;
        this.undoable = false;
        this.requiresBuildPermission = false;
        this.requiresBreakPermission = false;
        this.addHandlers(spell, parameters);
        for (ActionHandler handler : this.handlers.values()) {
            handler.initialize(spell, spell.getWorkingParameters());
            this.updateFlags(handler);
        }
        this.initialized = true;
    }

    protected void addHandlers(Spell spell, ConfigurationSection parameters) {
        this.addHandler(spell, "actions");
    }

    @Nullable
    protected ActionHandler getHandler(String handlerKey) {
        return this.handlers.get(handlerKey);
    }

    @Nullable
    protected ActionHandler addHandler(Spell spell, String handlerKey) {
        ActionHandler handler = this.handlers.get(handlerKey);
        this.handlerKeys.add(handlerKey);
        if (handler != null) {
            return handler;
        }
        if (this.actionConfiguration == null) {
            return null;
        }
        if (!this.actionConfiguration.contains(handlerKey)) {
            if (this.baseActions != null && spell.hasHandlerParameters(handlerKey)) {
                this.actionConfiguration.set(handlerKey, this.baseActions);
            }
        } else if (this.actionConfiguration.isString(handlerKey)) {
            this.actionConfiguration.set(handlerKey, this.actionConfiguration.get(this.actionConfiguration.getString(handlerKey)));
        }
        if (!this.actionConfiguration.isList(handlerKey)) {
            return null;
        }
        handler = new ActionHandler();
        handler.load(spell, this.actionConfiguration, handlerKey);
        this.handlers.put(handlerKey, handler);
        if (this.initialized) {
            handler.initialize(spell, spell.getWorkingParameters());
            this.updateFlags(handler);
        }
        return handler;
    }

    protected void updateFlags(ActionHandler handler) {
        this.usesBrush = this.usesBrush || handler.usesBrush();
        this.undoable = this.undoable || handler.isUndoable();
        this.requiresBuildPermission = this.requiresBuildPermission || handler.requiresBuildPermission();
        this.requiresBreakPermission = this.requiresBreakPermission || handler.requiresBreakPermission();
    }

    public void addAction(SpellAction action) {
        this.addAction(action, null);
    }

    public void addAction(SpellAction action, ConfigurationSection parameters) {
        ActionHandler actions = this.addHandler(null, "actions");
        if (actions == null) {
            return;
        }
        actions.loadAction(action, parameters);
    }

    @Override
    public boolean isUndoable() {
        return this.undoable;
    }

    @Override
    public boolean usesBrush() {
        return this.usesBrush;
    }

    @Override
    public boolean requiresBuildPermission() {
        return this.requiresBuildPermission;
    }

    @Override
    public boolean requiresBreakPermission() {
        return this.requiresBreakPermission;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        for (ActionHandler handler : this.handlers.values()) {
            handler.getParameterNames(spell, parameters);
        }
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        super.getParameterOptions(spell, parameterKey, examples);
        for (ActionHandler handler : this.handlers.values()) {
            handler.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public String transformMessage(String message) {
        for (ActionHandler handler : this.handlers.values()) {
            message = handler.transformMessage(message);
        }
        return message;
    }

    public void createActionContext(com.elmakers.mine.bukkit.api.action.CastContext context) {
        this.actionContext = new CastContext(context);
    }

    public void createActionContext(com.elmakers.mine.bukkit.api.action.CastContext context, Entity sourceEntity, Location sourceLocation) {
        this.actionContext = new CastContext(context, sourceEntity, sourceLocation);
    }

    public void createActionContext(com.elmakers.mine.bukkit.api.action.CastContext context, Entity sourceEntity, Location sourceLocation, Entity targetEntity, Location targetLocation) {
        this.actionContext = new CastContext(context, sourceEntity, sourceLocation);
        this.actionContext.setTargetEntity(targetEntity);
        this.actionContext.setTargetLocation(targetLocation);
    }

    public void createActionContext(com.elmakers.mine.bukkit.api.action.CastContext context, Mage sourceMage, Entity sourceEntity, Location sourceLocation, Entity targetEntity, Location targetLocation) {
        this.actionContext = sourceMage != null ? new CastContext(context, sourceMage, sourceEntity, sourceLocation) : new CastContext(context, sourceEntity, sourceLocation);
        this.actionContext.setTargetEntity(targetEntity);
        this.actionContext.setTargetLocation(targetLocation);
    }

    @Override
    public int getActionCount() {
        int actionCount = 0;
        for (ActionHandler handler : this.handlers.values()) {
            actionCount += handler.getActionCount();
        }
        return actionCount;
    }

    protected void skippedActions(com.elmakers.mine.bukkit.api.action.CastContext context) {
        this.skippedActions("actions", context);
    }

    protected void skippedActions(String key, com.elmakers.mine.bukkit.api.action.CastContext context) {
        ActionHandler actions = this.handlers.get(key);
        if (actions == null) {
            return;
        }
        int actionCount = actions.getActionCount();
        context.performedActions(actionCount);
        context.addWork(actionCount);
    }

    @Override
    @Nullable
    public Object clone() {
        CompoundAction action = (CompoundAction)super.clone();
        if (action != null) {
            action.handlers = new HashMap<String, ActionHandler>();
            for (Map.Entry<String, ActionHandler> entry : this.handlers.entrySet()) {
                action.handlers.put(entry.getKey(), (ActionHandler)entry.getValue().clone());
            }
        }
        return action;
    }

    @Nonnull
    public Collection<String> getAllHandlerKeys() {
        return this.handlerKeys;
    }

    protected static enum State {
        NOT_STARTED,
        STARTED,
        STEPPING;

    }
}

