/*
 * Decompiled with CFR 0.152.
 */
package me.xemu.NoMuteBypass.core;

import java.util.HashMap;
import me.xemu.NoMuteBypass.NoMuteBypass;
import me.xemu.NoMuteBypass.commands.CommandDSWM;
import me.xemu.NoMuteBypass.handler.Handler;
import me.xemu.NoMuteBypass.handler.IPunishmentSystem;
import me.xemu.NoMuteBypass.handler.punishment.AdvancedBanPunishmentSystem;
import me.xemu.NoMuteBypass.handler.punishment.AquaCorePunishmentSystem;
import me.xemu.NoMuteBypass.handler.punishment.EssentialsPunishmentSystem;
import me.xemu.NoMuteBypass.handler.punishment.LibertyBansPunishmentSystem;
import me.xemu.NoMuteBypass.handler.punishment.LiteBansListeners;
import me.xemu.NoMuteBypass.handler.punishment.LiteBansPunishmentSystem;
import me.xemu.NoMuteBypass.handler.punishment.PhoenixPunishmentSystem;
import me.xemu.NoMuteBypass.handler.punishment.PunishControlPunishmentSystem;
import me.xemu.NoMuteBypass.listeners.BlockListeners;
import me.xemu.NoMuteBypass.listeners.BookListeners;
import me.xemu.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Core {
    private NoMuteBypass noMuteBypass;
    private IPunishmentSystem system;

    public Core(NoMuteBypass noMuteBypass) {
        this.noMuteBypass = noMuteBypass;
    }

    public void commands() {
        try {
            this.noMuteBypass.getCommand("dswm").setExecutor((CommandExecutor)new CommandDSWM(this.noMuteBypass));
            Core.log("Registered new command 'dswm'");
        }
        catch (NullPointerException e) {
            Core.log("Could not register and handle new command: dswm");
            Core.log("Command Registration Failure: " + e.getMessage());
        }
    }

    public void listeners() {
        this.noMuteBypass.getServer().getPluginManager().registerEvents((Listener)new BlockListeners(this.noMuteBypass), (Plugin)this.noMuteBypass);
        this.noMuteBypass.getServer().getPluginManager().registerEvents((Listener)new BookListeners(this.noMuteBypass), (Plugin)this.noMuteBypass);
        new LiteBansListeners(this.noMuteBypass);
    }

    public IPunishmentSystem getSystem() {
        return this.system;
    }

    public void setSystem(IPunishmentSystem system) {
        this.system = system;
    }

    public static void log(String msg) {
        ConsoleCommandSender s = Bukkit.getConsoleSender();
        String prefix = "\u00a78[\u00a76NoMuteBypass\u00a78]";
        s.sendMessage(prefix + " \u00a7r" + msg);
    }

    public void handlePunishmentSystem() {
        String system = this.noMuteBypass.getConfig().getString("system.active");
        HashMap<String, Handler> systems = new HashMap<String, Handler>();
        systems.put("Essentials", new EssentialsPunishmentSystem(this.noMuteBypass));
        systems.put("LiteBans", new LiteBansPunishmentSystem(this.noMuteBypass));
        systems.put("PhoenixCore", new PhoenixPunishmentSystem(this.noMuteBypass));
        systems.put("AdvancedBan", new AdvancedBanPunishmentSystem(this.noMuteBypass));
        systems.put("AquaCore", new AquaCorePunishmentSystem(this.noMuteBypass));
        systems.put("LibertyBans", new LibertyBansPunishmentSystem(this.noMuteBypass));
        systems.put("PunishControl", new PunishControlPunishmentSystem(this.noMuteBypass));
        this.setSystem((IPunishmentSystem)systems.get(system));
    }

    public void handleConfig() {
        this.noMuteBypass.getConfig().options().copyDefaults(true);
        this.noMuteBypass.saveConfig();
    }

    public void sendDetailedStartupMessage() {
        String[] message;
        ConsoleCommandSender s = Bukkit.getConsoleSender();
        String activeSystem = "";
        activeSystem = this.getSystem() == null ? "No System Setup" : this.getSystem().getName();
        for (String part : message = new String[]{"\u00a78[]========[\u00a76NoMuteBypass\u00a78]========[]", "\u00a78| \u00a76Information:", "\u00a78|    \u00a76Plugin Version: \u00a7e" + this.noMuteBypass.getDescription().getVersion(), "\u00a78|    \u00a76Developer: \u00a7eXemu", "\u00a78|    \u00a76Active System: \u00a7e" + activeSystem, "\u00a78| \u00a76Support:", "\u00a78|    \u00a76Discord: \u00a7ehttps://discord.gg/mhzrNx8Ce3", "\u00a78|    \u00a76SpigotMC Username: \u00a7eXemu", "\u00a78[]========[\u00a76NoMuteBypass\u00a78]========[]"}) {
            s.sendMessage(part);
        }
    }

    public void metrics(JavaPlugin plugin) {
        int pluginId = 16644;
        Metrics metrics = new Metrics(plugin, 16644);
        Core.log("bStats handling completed.");
    }
}

