/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.visual;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.TechsCode.base.visual.Color;
import me.TechsCode.base.visual.ColorCalculations;

public class Text {
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("\\{#(([0-9A-Fa-f]){6}|([0-9A-Fa-f]){3})}");
    private static final Pattern HEX_GRADIENT_COLOR_PATTERN = Pattern.compile("(\\{(#[^{]*?)>})(.*?)(\\{(#.*?)<(>?)})");
    private static final Pattern STRIP_CHAT_COLOR_PATTERN = Pattern.compile("(\u00a7[0-9A-Fa-fK-ORk-or]|&[0-9A-Fa-fK-ORk-or])");

    public static String color(String text) {
        return Text.chatColor(Text.gradientColor(text));
    }

    public static String stripColor(String text) {
        return Text.stripHexColor(Text.stripChatColor(text));
    }

    public static String stripChatColor(String text) {
        return text.replaceAll(STRIP_CHAT_COLOR_PATTERN.pattern(), "");
    }

    public static String stripHexColor(String text) {
        return text.replaceAll(HEX_COLOR_PATTERN.pattern(), "");
    }

    public static String chatColor(String text) {
        Preconditions.checkArgument((text != null ? 1 : 0) != 0, (Object)"Text must be defined.");
        char[] characters = text.toCharArray();
        for (int i = 0; i < characters.length - 1; ++i) {
            if (characters[i] != '&' || "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(characters[i + 1]) <= -1) continue;
            characters[i] = 167;
            characters[i + 1] = Character.toLowerCase(characters[i + 1]);
        }
        return new String(characters);
    }

    public static String gradientColor(String text) {
        Matcher gradientMatch = HEX_GRADIENT_COLOR_PATTERN.matcher(text);
        while (gradientMatch.find()) {
            String fullMatch = gradientMatch.group();
            Color c1 = Color.from(gradientMatch.group(2).replace("#", "").replace("<", "").replace(">", ""));
            Color c2 = Color.from(gradientMatch.group(5).replace("#", "").replace("<", "").replace(">", ""));
            if (!c1.isValid() || !c2.isValid()) continue;
            String gText = gradientMatch.group(3);
            boolean continuous = !gradientMatch.group(6).isEmpty();
            StringBuilder updated = new StringBuilder();
            Set<String> formats = ColorCalculations.getFormats(gText);
            gText = Text.stripColor(gText);
            for (int i = 0; i < gText.length(); ++i) {
                char ch = gText.charAt(i);
                int length = gText.length();
                length = Math.max(length, 2);
                double percent = (double)i * 100.0 / (double)(length - 1);
                Color mix = ColorCalculations.getColorInBetweenPercent(c1, c2, percent);
                updated.append("{#").append(mix.getColorCode()).append("}");
                if (!formats.isEmpty()) {
                    for (String f : formats) {
                        updated.append("\u00a7").append(f);
                    }
                }
                updated.append(ch);
            }
            if (continuous) {
                updated.append("{#").append(gradientMatch.group(5).replace("#", "")).append(">").append("}");
            }
            text = text.replace(fullMatch, updated.toString());
            if (!continuous) continue;
            text = Text.gradientColor(text);
        }
        return Text.hexColor(Text.chatColor(text));
    }

    public static String hexColor(String text) {
        Preconditions.checkArgument((text != null ? 1 : 0) != 0, (Object)"Text must be defined.");
        Matcher matcher = HEX_COLOR_PATTERN.matcher(text);
        while (matcher.find()) {
            String hexColorTag = matcher.group();
            String colorCode = hexColorTag.replace("{#", "").replace("}", "");
            text = text.replace(hexColorTag, Color.from(colorCode).getAppliedTag());
        }
        return text;
    }

    public static String gradient(String text, Color ... colors) {
        Preconditions.checkArgument((colors.length > 1 ? 1 : 0) != 0, (Object)"Define 2 or more colors.");
        int charactersInSameFade = Math.max(1, text.length() / colors.length);
        ArrayList<Color> allColors = new ArrayList<Color>();
        int i = 0;
        for (Color all : colors) {
            Color next;
            Color color = next = colors.length == i + 1 ? null : colors[i + 1];
            if (next != null) {
                allColors.addAll(ColorCalculations.getColorsInBetween(all, next, charactersInSameFade));
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        i = 0;
        for (char character : text.toCharArray()) {
            Color color = allColors.size() <= i ? (Color)allColors.get(allColors.size() - 1) : (Color)allColors.get(i);
            sb.append(color.getAppliedTag()).append(character);
            ++i;
        }
        return sb.toString();
    }

    public static String firstUpperCase(String text) {
        return text.substring(0, 1).toUpperCase() + text.substring(1).toLowerCase();
    }
}

