/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.visual;

import me.TechsCode.base.visual.Color;

public enum MinecraftColor {
    DARK_RED("&4", "#AA0000"),
    RED("&c", "#FF5555"),
    GOLD("&6", "#FFAA00"),
    YELLOW("&e", "#FFFF55"),
    DARK_GREEN("&2", "#00AA00"),
    GREEN("&a", "#55FF55"),
    AQUA("&b", "#55FFFF"),
    DARK_AQUA("&3", "#00AAAA"),
    DARK_BLUE("&1", "#0000AA"),
    BLUE("&9", "#5555FF"),
    LIGHT_PURPLE("&d", "#FF55FF"),
    DARK_PURPLE("&5", "#AA00AA"),
    WHITE("&f", "#FFFFFF"),
    GRAY("&7", "#AAAAAA"),
    DARK_GRAY("&8", "#555555"),
    BLACK("&0", "#000000");

    private final String chatColor;
    private final Color color;

    public static MinecraftColor getClosest(Color color) {
        MinecraftColor closest = null;
        int closestDifference = 0;
        for (MinecraftColor defaultColor : MinecraftColor.values()) {
            int difference = Color.difference(color, defaultColor.getColor());
            if (closest != null && closestDifference <= difference) continue;
            closestDifference = difference;
            closest = defaultColor;
        }
        return closest;
    }

    private MinecraftColor(String chatColor, String hexColorCode) {
        this.chatColor = chatColor;
        this.color = Color.from(hexColorCode);
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    public Color getColor() {
        return this.color;
    }

    public String getTag() {
        return this.chatColor;
    }

    public String getAppliedTag() {
        return this.chatColor.replace("&", "\u00a7");
    }

    public String toString() {
        return this.getAppliedTag();
    }
}

