/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.visual;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.TechsCode.base.visual.Color;

public class ColorCalculations {
    private static final Pattern FORMAT_PATTERN = Pattern.compile("(&[klmnorKLMNOR])");

    public static List<Color> getColorsInBetween(Color first, Color second, int amount) {
        double rStep = (double)(second.getRed() - first.getRed()) / (double)amount;
        double gStep = (double)(second.getGreen() - first.getGreen()) / (double)amount;
        double bStep = (double)(second.getBlue() - first.getBlue()) / (double)amount;
        ArrayList<Color> colors = new ArrayList<Color>();
        for (int i = 1; i <= amount; ++i) {
            int r = (int)Math.round((double)first.getRed() + rStep * (double)i);
            int g = (int)Math.round((double)first.getGreen() + gStep * (double)i);
            int b = (int)Math.round((double)first.getBlue() + bStep * (double)i);
            Color color = Color.from(r, g, b);
            colors.add(color);
        }
        return colors;
    }

    public static Color getColorInBetweenPercent(Color first, Color second, double percent) {
        double inverse_percent = 1.0 - (percent /= 100.0);
        int redPart = (int)((double)second.getRed() * percent + (double)first.getRed() * inverse_percent);
        int greenPart = (int)((double)second.getGreen() * percent + (double)first.getGreen() * inverse_percent);
        int bluePart = (int)((double)second.getBlue() * percent + (double)first.getBlue() * inverse_percent);
        return Color.from(redPart, greenPart, bluePart);
    }

    public static Set<String> getFormats(String text) {
        text = text.replace("\u00a7", "&");
        HashSet<String> formats = new HashSet<String>();
        Matcher match = FORMAT_PATTERN.matcher(text);
        while (match.find()) {
            formats.add(match.group());
        }
        return formats;
    }
}

