/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.visual;

import java.util.Arrays;
import java.util.stream.Collectors;
import me.TechsCode.base.visual.MinecraftColor;

public class Color {
    private static final String HEX_PATTERN = "(#(([0-9A-Fa-f]){6}|([0-9A-Fa-f]){3}))|(([0-9A-Fa-f]){6}|([0-9A-Fa-f]){3})";
    private String colorCode;
    private final int r;
    private final int g;
    private final int b;
    private final boolean valid;

    public static Color from(String colorCode) {
        return new Color(colorCode);
    }

    public static Color from(int r, int g, int b) {
        java.awt.Color color = new java.awt.Color(r, g, b);
        return Color.from(Integer.toHexString(color.getRGB()).substring(2));
    }

    private Color(String colorCode) {
        if (!colorCode.matches(HEX_PATTERN)) {
            this.valid = false;
            this.b = 0;
            this.g = 0;
            this.r = 0;
        } else {
            this.valid = true;
            this.colorCode = colorCode.replace("#", "");
            if (this.colorCode.length() == 3) {
                String[] split = this.colorCode.split("");
                this.colorCode = split[0] + split[0] + split[1] + split[1] + split[2] + split[2];
            }
            java.awt.Color color = new java.awt.Color(Integer.parseInt(this.colorCode, 16));
            this.r = color.getRed();
            this.g = color.getGreen();
            this.b = color.getBlue();
        }
    }

    public String getTag() {
        return "{#" + this.colorCode + "}";
    }

    public String getColorCode() {
        return this.colorCode;
    }

    public int getRed() {
        return this.r;
    }

    public int getGreen() {
        return this.g;
    }

    public int getBlue() {
        return this.b;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getAppliedTag() {
        return this.isValid() ? (Color.hasHexSupport() ? "\u00a7x" + Arrays.stream(this.colorCode.split("")).map(s2 -> "\u00a7" + s2).collect(Collectors.joining()) : MinecraftColor.getClosest(this).getAppliedTag()) : "";
    }

    public String getColorTag() {
        return "{#" + this.colorCode + "}";
    }

    public static int difference(Color a, Color b) {
        return Math.abs(a.r - b.r) + Math.abs(a.g - b.g) + Math.abs(a.b - b.b);
    }

    public static boolean hasHexSupport() {
        return false;
    }

    public String toString() {
        return this.getAppliedTag();
    }
}

