/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.visual;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import me.TechsCode.base.visual.Color;
import me.TechsCode.base.visual.ColorCalculations;

public class Animation {
    private static final HashMap<String, List<String>> animationCache = new HashMap();

    public static String wave(String text, Color ... colors) {
        return Animation.wave(text, true, 5, 10, colors);
    }

    public static String wave(String text, boolean bold, int stay, int transition, Color ... colors) {
        Preconditions.checkArgument((colors.length > 1 ? 1 : 0) != 0, (Object)"Not enough colors provided");
        String identifier = "wave-" + text + "-" + bold + "-" + stay + "-" + transition + "-" + Arrays.stream(colors).map(Color::getColorCode).collect(Collectors.joining("-"));
        if (animationCache.containsKey(identifier)) {
            return Animation.currentFrame(animationCache.get(identifier));
        }
        ArrayList<String> frames = new ArrayList<String>();
        int i = 0;
        for (Color all : colors) {
            Color next = colors[colors.length == i + 1 ? 0 : i + 1];
            frames.addAll(Collections.nCopies(stay, all.getAppliedTag() + (bold ? "\u00a7l" : "") + text));
            ArrayList<String> transitionColors = new ArrayList<String>();
            transitionColors.addAll(Collections.nCopies(text.length(), all.getAppliedTag()));
            transitionColors.addAll(ColorCalculations.getColorsInBetween(all, next, transition).stream().map(Color::getAppliedTag).collect(Collectors.toList()));
            transitionColors.addAll(Collections.nCopies(text.length(), next.getAppliedTag()));
            for (int offset = 0; offset <= transitionColors.size() - text.length(); ++offset) {
                StringBuilder sb = new StringBuilder();
                int x = 0;
                for (char character : text.toCharArray()) {
                    String color = (String)transitionColors.get(x + offset);
                    sb.append(color).append(bold ? "\u00a7l" : "").append(character);
                    ++x;
                }
                frames.add(sb.toString());
            }
            frames.addAll(Collections.nCopies(stay, next.getAppliedTag() + (bold ? "\u00a7l" : "") + text));
            ++i;
        }
        animationCache.put(identifier, frames);
        return Animation.currentFrame(frames);
    }

    public static String fading(String text, Color ... colors) {
        return Animation.fading(text, true, 10, 20, colors);
    }

    public static String fading(String text, boolean bold, int stay, int transition, Color ... colors) {
        Preconditions.checkArgument((colors.length > 1 ? 1 : 0) != 0, (Object)"Not enough colors provided");
        String identifier = "fading-" + text + "-" + bold + "-" + stay + "-" + transition + "-" + Arrays.stream(colors).map(Color::getColorCode).collect(Collectors.joining("-"));
        if (animationCache.containsKey(identifier)) {
            return Animation.currentFrame(animationCache.get(identifier));
        }
        ArrayList<String> frames = new ArrayList<String>();
        int i = 0;
        for (Color all : colors) {
            Color next = colors[colors.length == i + 1 ? 0 : i + 1];
            frames.addAll(Collections.nCopies(stay, all.getAppliedTag() + (bold ? "\u00a7l" : "") + text));
            for (Color inbetween : ColorCalculations.getColorsInBetween(all, next, transition)) {
                frames.add(inbetween.getAppliedTag() + (bold ? "\u00a7l" : "") + text);
            }
            ++i;
        }
        animationCache.put(identifier, frames);
        return Animation.currentFrame(frames);
    }

    private static String currentFrame(List<String> frames) {
        long tick = System.currentTimeMillis() / 50L;
        int currentFrame = (int)(tick % (long)frames.size());
        return frames.get(currentFrame);
    }
}

