/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.storage;

import com.google.gson.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import me.TechsCode.base.TechPlugin;
import me.TechsCode.base.storage.ReadCallback;
import me.TechsCode.base.storage.Storable;
import me.TechsCode.base.storage.StorageImplementation;
import me.TechsCode.base.storage.WriteCallback;

public abstract class Storage<STORABLE extends Storable> {
    protected TechPlugin<?> plugin;
    private final Class<? extends Storable> storable;
    private StorageImplementation implementation;
    private Map<String, STORABLE> instances;

    public Storage(final TechPlugin<?> plugin, String name, final Class<? extends Storable> storable, Class<? extends StorageImplementation> implementation, boolean syncWithOtherInstances) {
        this.plugin = plugin;
        this.storable = storable;
        try {
            this.implementation = implementation.getConstructor(TechPlugin.class, String.class).newInstance(plugin, name);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return;
        }
        this.instances = new HashMap<String, STORABLE>();
        this.implementation.read("*", new ReadCallback(){

            @Override
            public void onSuccess(HashMap<String, JsonObject> data) {
                Storage.this.createInstances(data);
            }

            @Override
            public void onFailure(Exception e) {
                plugin.log("Could not retrieve data from Storage '" + storable.getName() + "' :");
                plugin.log(e.getMessage());
            }
        });
    }

    private void createInstances(Map<String, JsonObject> map) {
    }

    public void syncFromDatabase(final String key) {
        this.plugin.getScheduler().runAsync(() -> this.implementation.read(key, new ReadCallback(){

            @Override
            public void onSuccess(HashMap<String, JsonObject> map) {
                if (key.equalsIgnoreCase("*")) {
                    Map<String, JsonObject> newEntries = map.entrySet().stream().filter(pair -> !Storage.this.instances.containsKey(pair.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    Storage.this.createInstances(newEntries);
                    Map<String, JsonObject> changedEntries = map.entrySet().stream().filter(pair -> Storage.this.instances.containsKey(pair.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    for (Map.Entry<String, JsonObject> entry : changedEntries.entrySet()) {
                        Storable instance = (Storable)Storage.this.instances.get(entry.getKey());
                        if (instance.getState().toString().equalsIgnoreCase(entry.getValue().toString())) continue;
                        instance.setState(entry.getValue(), Storage.this.plugin);
                        instance.setLastSyncedState(entry.getValue());
                    }
                    Map<String, Storable> deletedEntries = Storage.this.instances.entrySet().stream().filter(pair -> !map.containsKey(pair.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    deletedEntries.forEach((key1, value) -> {
                        Storable cfr_ignored_0 = (Storable)Storage.this.instances.remove(key1);
                    });
                } else if (!map.isEmpty() && !Storage.this.instances.containsKey(key)) {
                    Storage.this.createInstances(map);
                } else if (!map.isEmpty() && Storage.this.instances.containsKey(key)) {
                    ((Storable)Storage.this.instances.get(key)).setState(map.get(key), Storage.this.plugin);
                    ((Storable)Storage.this.instances.get(key)).setLastSyncedState(map.get(key));
                } else if (map.isEmpty()) {
                    Storage.this.instances.remove(key);
                }
                Storage.this.onDataSynchronization();
            }

            @Override
            public void onFailure(Exception e) {
                Storage.this.plugin.log("Could not update Storage Instances of Storage '" + Storage.this.storable.getName() + "' :");
                Storage.this.plugin.log(e.getMessage());
            }
        }));
    }

    public Collection<STORABLE> get() {
        return this.instances.values();
    }

    void update(Storable storable, JsonObject newState) {
    }

    void destroy(Storable storable) {
    }

    public STORABLE create(STORABLE storable) {
        ((Storable)storable).onMount(this.plugin);
        ((Storable)storable).setStorage(this);
        this.onMount(storable);
        this.instances.put(((Storable)storable).getKey(), storable);
        this.onCreation(storable);
        this.implementation.create(((Storable)storable).getKey(), ((Storable)storable).getState(), new WriteCallback((Storable)storable){
            final /* synthetic */ Storable val$storable;
            {
                this.val$storable = storable;
            }

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure(Exception e) {
                Storage.this.plugin.log("Could not create '" + this.val$storable.getKey() + "' of '" + Storage.this.storable.getName() + "' :");
                Storage.this.plugin.log("" + e.getMessage());
                Storage.this.plugin.log("Json Data:");
                Storage.this.plugin.log(this.val$storable.getState().toString());
                Storage.this.plugin.log("It is strongly advised to restart the Server!");
            }
        });
        return storable;
    }

    public int getNextNumericId() {
        return this.instances.keySet().stream().mapToInt(Integer::parseInt).max().orElse(0) + 1;
    }

    public Class<? extends Storable> getModel() {
        return this.storable;
    }

    public String getModelName() {
        return this.getModel().getName();
    }

    public abstract void onMount(STORABLE var1);

    public abstract void onCreation(STORABLE var1);

    public abstract void onChange(STORABLE var1, STORABLE var2);

    public abstract void onDestroy(STORABLE var1);

    public abstract void onDataSynchronization();
}

