/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.storage;

import com.google.gson.JsonObject;
import me.TechsCode.base.TechPlugin;
import me.TechsCode.base.storage.Storage;

public abstract class Storable {
    protected Storage<?> storage;
    private JsonObject lastSyncedState;

    public void setStorage(Storage<?> storage) {
        this.storage = storage;
    }

    protected void sync() {
        if (this.storage != null) {
            JsonObject newState = this.getState();
            if (this.lastSyncedState == null || !this.lastSyncedState.toString().equalsIgnoreCase(newState.toString())) {
                this.storage.update(this, newState);
                this.lastSyncedState = newState;
            }
        }
    }

    public void setLastSyncedState(JsonObject lastSyncedState) {
        this.lastSyncedState = lastSyncedState;
    }

    public JsonObject getLastSyncedState() {
        return this.lastSyncedState;
    }

    protected void destroy() {
        if (this.storage != null) {
            this.storage.destroy(this);
            this.storage = null;
        }
    }

    public abstract String getKey();

    public abstract void setKey(String var1);

    public abstract JsonObject getState();

    public abstract void setState(JsonObject var1, TechPlugin<?> var2);

    public boolean isLinkedToStorage() {
        return this.storage != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Storable)) {
            return false;
        }
        Storable o = (Storable)obj;
        return o.getKey().equals(this.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public abstract void onMount(TechPlugin<?> var1);
}

