/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.source;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.TechsCode.base.SpigotTechPlugin;
import me.TechsCode.base.TechPlugin;
import me.TechsCode.base.source.Dependency;
import me.TechsCode.base.source.JarClassLoader;
import me.TechsCode.base.source.LocalRepository;

public class Maven {
    private static boolean initialized = false;
    private static TechPlugin plugin;
    private static final List<String> repositories;
    private static JarClassLoader classLoader;
    private static LocalRepository localRepository;
    private static Set<Dependency> loadedDependencies;
    private static Set<Dependency> failedDependencies;

    public static void initialize(SpigotTechPlugin plugin) {
        if (initialized) {
            return;
        }
        Maven.plugin = plugin;
        classLoader = new JarClassLoader(plugin);
        localRepository = new LocalRepository(plugin);
        loadedDependencies = new HashSet<Dependency>();
        failedDependencies = new HashSet<Dependency>();
        initialized = true;
    }

    public static void addRepository(String url) {
        Preconditions.checkArgument((boolean)initialized, (Object)"Call #initialize before using Maven");
        if (!repositories.contains(url)) {
            repositories.add(url);
        }
    }

    public static boolean loadDependency(String groupId, String artifactId, String version) {
        Dependency dependency = new Dependency(groupId, artifactId, version);
        return Maven.loadDependency(dependency);
    }

    public static boolean loadDependency(Dependency dependency) {
        Preconditions.checkArgument((boolean)initialized, (Object)"Call #initialize before using Maven");
        if (failedDependencies.contains(dependency)) {
            return false;
        }
        if (loadedDependencies.contains(dependency)) {
            return true;
        }
        File file = localRepository.getIfPresent(dependency);
        if (file == null) {
            localRepository.load(dependency, repositories);
            file = localRepository.getIfPresent(dependency);
        }
        if (file != null) {
            loadedDependencies.add(dependency);
            plugin.log("Loaded dependency " + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion());
        } else {
            failedDependencies.add(dependency);
            plugin.log("Could not load " + dependency.getGroupId() + " / " + dependency.getArtifactId() + " on " + dependency.getVersion());
        }
        return file != null;
    }

    public static boolean isLoaded(Dependency dependency) {
        return loadedDependencies.contains(dependency);
    }

    static {
        repositories = new ArrayList<String>(Collections.singletonList("https://repo1.maven.org/maven2"));
    }
}

