/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.scheduler;

import me.TechsCode.base.SpigotTechPlugin;
import me.TechsCode.base.scheduler.RecurringTask;
import me.TechsCode.base.scheduler.Scheduler;
import me.TechsCode.base.scheduler.Task;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class SpigotScheduler
implements Scheduler {
    private SpigotTechPlugin plugin;

    public SpigotScheduler(SpigotTechPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run(Runnable task) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin.getBootstrap(), task);
    }

    @Override
    public void runAsync(Runnable task) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin.getBootstrap(), task);
    }

    @Override
    public Task runTaskLater(Runnable task, long delay) {
        BukkitTask t = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin.getBootstrap(), task, delay);
        return this.toGenericTask(t);
    }

    @Override
    public RecurringTask runTaskTimer(Runnable task, long delay, long period) {
        return this.toRecurringTask(() -> Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin.getBootstrap(), task, delay, period));
    }

    @Override
    public Task runTaskLaterAsync(Runnable task, long delay) {
        BukkitTask t = Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin.getBootstrap(), task, delay);
        return this.toGenericTask(t);
    }

    @Override
    public RecurringTask runTaskTimerAsync(Runnable task, long delay, long period) {
        return this.toRecurringTask(() -> Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin.getBootstrap(), task, delay, period));
    }

    private Task toGenericTask(final BukkitTask bukkitTask) {
        return new Task(){

            @Override
            public void cancel() {
                bukkitTask.cancel();
            }
        };
    }

    private RecurringTask toRecurringTask(final TaskCreator creator) {
        return new RecurringTask(){
            private BukkitTask bukkitTask;
            {
                this.bukkitTask = creator.build();
            }

            @Override
            public void stop() {
                if (this.bukkitTask != null) {
                    this.bukkitTask.cancel();
                    this.bukkitTask = null;
                }
            }

            @Override
            public void start() {
                if (this.bukkitTask == null) {
                    this.bukkitTask = creator.build();
                }
            }
        };
    }

    static interface TaskCreator {
        public BukkitTask build();
    }
}

