/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.registry;

import me.TechsCode.base.TechPlugin;
import me.TechsCode.base.registry.BiRegistry;
import me.TechsCode.base.registry.Registration;
import me.TechsCode.base.registry.RegistrationChoice;
import me.TechsCode.base.registry.RegistryStorable;
import me.TechsCode.base.registry.RegistryStorage;
import me.TechsCode.base.registry.RegistryStorageEntry;

public class Registry {
    private TechPlugin<?> plugin;
    private RegistryStorage local;
    private RegistryStorage global;

    public Registry(TechPlugin<?> plugin) {
    }

    private void startRemoteRegistry() {
    }

    public <T extends RegistryStorable> BiRegistry<T> register(Class<? extends T> storableClass) {
        try {
            RegistryStorable storable = (RegistryStorable)storableClass.newInstance();
            return this.register(storable);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T extends RegistryStorable> BiRegistry<T> register(T storable) {
        T local = this.register(storable, RegistrationChoice.LOCAL);
        T global = this.register(storable, RegistrationChoice.GLOBAL);
        return new BiRegistry<T>(local, global);
    }

    public <T extends RegistryStorable> T register(Class<? extends T> storableClass, RegistrationChoice registrationChoice) {
        try {
            RegistryStorable storable = (RegistryStorable)storableClass.newInstance();
            return (T)this.register(storable, registrationChoice);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T extends RegistryStorable> T register(T storable, RegistrationChoice registrationChoice) {
        this.startRemoteRegistry();
        Registration registration = null;
        switch (registrationChoice) {
            case LOCAL: {
                registration = Registration.LOCAL;
                break;
            }
            case GLOBAL: {
                registration = this.global != null ? Registration.GLOBAL : null;
                break;
            }
            case GLOBAL_IF_AVAILABLE: {
                Registration registration2 = registration = this.global != null ? Registration.GLOBAL : Registration.LOCAL;
            }
        }
        if (registration == null) {
            return null;
        }
        RegistryStorage storage = registration == Registration.LOCAL ? this.local : this.global;
        RegistryStorageEntry registryStorageEntry = storage.retrieve(new RegistryStorageEntry(storable.getKey(), storable.getState()));
        storable.setStorageEntry(registryStorageEntry);
        storable.setState(registryStorageEntry.getState());
        return storable;
    }
}

