/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.networking;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Optional;
import me.TechsCode.base.SpigotTechPlugin;
import me.TechsCode.base.networking.NServer;
import me.TechsCode.base.networking.NetworkData;
import org.bukkit.plugin.java.JavaPlugin;

public class SpigotNetworkManager {
    private SpigotTechPlugin plugin;
    private String ownIpAddress;
    private NetworkData networkData;

    public SpigotNetworkManager(SpigotTechPlugin plugin) {
        this.plugin = plugin;
        this.ownIpAddress = this.retrieveOwnIpAddress();
        plugin.getMessagingService().register(message -> {
            if (message.getKey().equals("networking")) {
                this.networkData = NetworkData.fromJsonObject(message.getData());
            }
        });
    }

    private String retrieveOwnIpAddress() {
        try {
            return new BufferedReader(new InputStreamReader(new URL("http://checkip.amazonaws.com").openStream())).readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Optional<NetworkData> getData() {
        return Optional.ofNullable(this.networkData);
    }

    public Optional<NServer> getThisServer() {
        if (this.networkData == null) {
            return Optional.empty();
        }
        int port = ((JavaPlugin)this.plugin.getBootstrap()).getServer().getPort();
        return this.networkData.getServerList().stream().filter(server -> server.getIp().equals(this.ownIpAddress) && server.getPort() == port).findFirst();
    }

    public Optional<NServer> getServerFromName(String name) {
        if (this.networkData == null) {
            return Optional.empty();
        }
        return this.networkData.getServerList().stream().filter(server -> server.getName().equalsIgnoreCase(name)).findFirst();
    }
}

