/*
 * Decompiled with CFR 0.152.
 */
package me.TechsCode.base.networking;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.TechsCode.base.networking.ServerList;

public class NetworkData {
    private String proxyPluginVersion;
    private ServerList serverList;

    public NetworkData(String proxyPluginVersion, ServerList serverList) {
        this.proxyPluginVersion = proxyPluginVersion;
        this.serverList = serverList;
    }

    public String getProxyPluginVersion() {
        return this.proxyPluginVersion;
    }

    public ServerList getServerList() {
        return this.serverList;
    }

    public JsonObject toJsonObject() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("proxyVersion", this.proxyPluginVersion);
        jsonObject.add("serverList", (JsonElement)this.serverList.toJsonArray());
        return jsonObject;
    }

    public static NetworkData fromJsonObject(JsonObject jsonObject) {
        String proxyPluginVersion = jsonObject.get("proxyVersion").getAsString();
        ServerList serverList = new ServerList(jsonObject.getAsJsonArray("serverList"));
        return new NetworkData(proxyPluginVersion, serverList);
    }
}

